/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.GameData;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FrameInfo
implements GameData {
    static final int MAME_DATAGRAM_SIZE = 1026;
    private static final int ID_BYTE = 1024;
    private static final int PING_BYTE = 1025;
    private static final int MASK_OPCODE = 240;
    private static final int OPCODE_LABS = 160;
    private static final int OPCODE_HALT = 176;
    private static final int OPCODE_JSRL = 192;
    private static final int OPCODE_RTSL = 208;
    private static final int OPCODE_JMPL = 224;
    private static final int OPCODE_SVEC = 240;
    private static final int OPCODE_SHIP = 96;
    private static final int SUB_ASTEROID_TYPE1 = 2291;
    private static final int SUB_ASTEROID_TYPE2 = 2303;
    private static final int SUB_ASTEROID_TYPE3 = 2317;
    private static final int SUB_ASTEROID_TYPE4 = 2330;
    private static final int SUB_UFO = 2345;
    private final byte id;
    private final byte ping;
    private Ufo ufo;
    private List<Asteroid> asteroids = new LinkedList<Asteroid>();
    private SpaceShip spaceShip;
    private List<Bullet> bullets = new LinkedList<Bullet>();
    private final long receiveTime;
    private final long pingTime;

    private static int byteToUnsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    FrameInfo(byte[] bytes, long[] pingTimes) throws IOException {
        if (bytes.length != 1026) {
            throw new IOException("Incorrect datagram with size " + bytes.length);
        }
        if ((bytes[1] & 0xF0) != 224) {
            throw new IOException(String.format("Incorrect vector buffer start: %02x%02x", bytes[0], bytes[1]));
        }
        this.receiveTime = System.currentTimeMillis();
        this.id = bytes[1024];
        this.ping = bytes[1025];
        this.pingTime = this.ping != 0 ? this.receiveTime - pingTimes[this.ping] : 0L;
        int vx = 0;
        int vy = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int dx = 0;
        int dy = 0;
        boolean possibleShip = false;
        int p = 2;
        block15: while (p < 1024) {
            int highbyte = FrameInfo.byteToUnsigned(bytes[p + 1]);
            int opcode = highbyte & 0xF0;
            switch (opcode) {
                case 160: {
                    vy = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                    highbyte = FrameInfo.byteToUnsigned(bytes[(p += 2) + 1]);
                    vx = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                    vs = highbyte >> 4;
                    p += 2;
                    continue block15;
                }
                case 176: {
                    return;
                }
                case 192: {
                    switch ((highbyte & 0xF) << 8 | FrameInfo.byteToUnsigned(bytes[p])) {
                        case 2291: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 0));
                            break;
                        }
                        case 2303: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 1));
                            break;
                        }
                        case 2317: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 2));
                            break;
                        }
                        case 2330: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 3));
                            break;
                        }
                        case 2345: {
                            this.ufo = new Ufo(vx, vy, vs);
                        }
                    }
                    p += 2;
                    continue block15;
                }
                case 208: {
                    return;
                }
                case 224: {
                    return;
                }
                case 240: {
                    p += 2;
                    continue block15;
                }
            }
            if (this.spaceShip == null) {
                dy = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                if ((highbyte & 4) != 0) {
                    dy = -dy;
                }
                highbyte = FrameInfo.byteToUnsigned(bytes[(p += 2) + 1]);
                dx = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                if ((highbyte & 4) != 0) {
                    dx = -dx;
                }
                int vz = highbyte >> 4;
                if (dx == 0 && dy == 0 && vz == 15) {
                    this.bullets.add(new Bullet(vx, vy));
                }
                if (dx != 0 && dy != 0) {
                    if (opcode == 96 && vz == 12) {
                        if (possibleShip) {
                            if (this.spaceShip == null) {
                                this.spaceShip = new SpaceShip(vx, vy, v1x - dx, v1y - dy);
                            }
                            possibleShip = false;
                        } else {
                            v1x = dx;
                            v1y = dy;
                            possibleShip = true;
                        }
                    }
                } else if (possibleShip) {
                    possibleShip = false;
                }
                p += 2;
                continue;
            }
            p += 4;
        }
    }

    public void draw(Graphics2D g) {
        for (Asteroid asteroid : this.asteroids) {
            asteroid.draw(g);
        }
        if (this.ufo != null) {
            this.ufo.draw(g);
        }
        if (this.spaceShip != null) {
            this.spaceShip.draw(g);
        }
        for (Bullet bullet : this.bullets) {
            bullet.draw(g);
        }
    }

    public byte getId() {
        return this.id;
    }

    public int getPing() {
        return this.ping;
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public Ufo getUfo() {
        return this.ufo;
    }

    public Collection<Asteroid> getAsteroids() {
        return Collections.unmodifiableCollection(this.asteroids);
    }

    public SpaceShip getSpaceShip() {
        return this.spaceShip;
    }

    public Collection<Bullet> getBullets() {
        return Collections.unmodifiableCollection(this.bullets);
    }
}

