/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class GameObject
implements GameData {
    private static int minY = Integer.MAX_VALUE;
    private static int maxY = Integer.MIN_VALUE;
    protected final int x;
    protected final int y;

    protected GameObject(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getCenter() {
        return new Point(this.x, this.y);
    }

    public abstract int getSize();

    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        int size = this.getSize();
        g.drawOval(this.x - size, this.y - size, 2 * size, 2 * size);
    }

    public Point getDelta(GameObject obj) {
        int dx = obj.x - this.x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = obj.y - this.y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return new Point(dx, dy);
    }

    public int getSquaredDistance(GameObject obj) {
        int dx = obj.x - this.x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = obj.y - this.y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return dx * dx + dy * dy;
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }
}

