/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.awt.Point;
import java.io.IOException;

public class SampleAsteroidPlayer
implements FrameListener,
GameData {
    private int t;
    private Communication com;

    public SampleAsteroidPlayer(Communication com) {
        this.com = com;
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        SpaceShip ship;
        if (frame != null && (ship = frame.getSpaceShip()) != null) {
            int keys = 0;
            GameObject target = SampleAsteroidPlayer.findNearestTarget(ship, frame);
            if (target == null) {
                keys |= 4;
            } else {
                Point delta = ship.getDelta(target);
                int dist2 = delta.x * delta.x + delta.y * delta.y;
                keys = dist2 < 729 ? (keys |= 1) : (keys |= ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0 ? 16 : 8);
            }
            if (this.t++ % 2 == 0) {
                keys |= 2;
            }
            try {
                this.com.sendKeys(keys);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static GameObject findNearestTarget(SpaceShip ship, FrameInfo info) {
        int dist2;
        GameObject nearest = null;
        int minDist2 = 160000;
        for (Asteroid ast : info.getAsteroids()) {
            int dist22 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
            if (dist22 >= minDist2) continue;
            minDist2 = dist22;
            nearest = ast;
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize()) < minDist2) {
            nearest = ufo;
        }
        return nearest;
    }
}

