/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class SpaceShip
extends GameObject {
    private static final Color COLOR = new Color(192, 192, 192);
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    private final int dx;
    private final int dy;

    public SpaceShip(int x, int y, int dx, int dy) {
        super(x, y);
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public int getSize() {
        return 16;
    }

    public int getDirX() {
        return this.dx;
    }

    public int getDirY() {
        return this.dy;
    }

    public double getDirectionAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        AffineTransform at = AffineTransform.getTranslateInstance(this.x, this.y);
        at.concatenate(AffineTransform.getRotateInstance(this.getDirectionAngle()));
        g.fill(at.createTransformedShape(SHIP_SHAPE));
    }

    public String toString() {
        return String.format("SpaceShip@(%d,%d)>(%.1f\u00b0)", this.x, this.y, 180.0 * this.getDirectionAngle() / Math.PI);
    }

    static {
        SHIP_SHAPE.moveTo(16.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, 8.0f);
        SHIP_SHAPE.lineTo(-8.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, -8.0f);
        SHIP_SHAPE.closePath();
    }
}

