/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Ufo
extends GameObject {
    private static final GeneralPath BIG = new GeneralPath();
    private static final GeneralPath SMALL;
    private final boolean big;

    public Ufo(int x, int y, int size) {
        super(x, y);
        this.big = size == 15;
    }

    @Override
    public int getSize() {
        return this.big ? 16 : 8;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        g.draw(AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.big ? BIG : SMALL));
    }

    public String toString() {
        return String.format("Ufo@(%d,%d)*%d", this.x, this.y, this.getSize());
    }

    static {
        int w = 24;
        int h = 8;
        BIG.moveTo(-w, 0.0f);
        BIG.lineTo(w, 0.0f);
        BIG.lineTo(w / 2, -h);
        BIG.lineTo(-w / 2, -h);
        BIG.lineTo(-w, 0.0f);
        BIG.lineTo(-w / 2, h);
        BIG.lineTo(w / 2, h);
        BIG.lineTo(w, 0.0f);
        BIG.moveTo(-h, h);
        BIG.lineTo(-2 * h / 3, 2 * h);
        BIG.lineTo(2 * h / 3, 2 * h);
        BIG.lineTo(h, h);
        SMALL = new GeneralPath(BIG);
        SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
    }
}

