// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;

/**
 *  Component to display a frame as received from MAME.
 *
 *  Because this an example of a frame listener note the usage of synchronized access to
 *  the frameInfo object passed between threads and the usage of repaint() to inform the AWT
 *  thread to start drawing.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class FrameDisplay
  extends JComponent
  implements FrameListener,
             GameData
{
  /** The currently displayed frame info. */
  private FrameInfo frameInfo;
  /** The transformation from frame space into component space. */
  private AffineTransform trafo;

  /**
   *  Constructor.
   *
   *  The component is always constructed with a aspect ratio of 4:3.
   *  @param width width to use for this component
   */
  public FrameDisplay(int width)
  {
    Dimension size = new Dimension(width, 3*width/4);
    setMaximumSize(size);
    setMinimumSize(size);
    setPreferredSize(size);
    setOpaque(true);
    setDoubleBuffered(true);

    double scaling = width/(double)EXTENT;
    // NOTE: take care of y pointing upwards in Asteroids, but downwards on screen
    trafo = AffineTransform.getTranslateInstance(0, MIN_Y-EXTENT);
    trafo.preConcatenate(AffineTransform.getScaleInstance(scaling, -scaling));
 }

  /**
   * Paint this frame.
   *
   * @param g the <code>Graphics</code> object to protect
   * @see #paint
   * @see javax.swing.plaf.ComponentUI
   */
  @Override
  protected void paintComponent(Graphics g)
  {
    g.setColor(Color.black);
    g.fillRect(0, 0, getWidth(), getHeight());
    FrameInfo info;
    synchronized (this) {
      info = frameInfo;
    }
    if (info != null) {
      Graphics2D g2 = (Graphics2D)g;
      g2.transform(trafo);
      info.draw(g2);
    }
  }

  /**
   *  Called each time a frame is received.
   *
   *  <b>ATTENTION:</b> this is called from the communication thread!
   *  Implementing classes must be aware of this and take care by synchronization or similar!
   *  @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    synchronized (this) {
      frameInfo = frame;
    }
    repaint();
  }
}
