// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;

/**
 *  Generic game object in Asteroid game.
 *
 *  A game object has a position and a size and it can be drawn.
 * 
 *  This is part of a solution for a competition
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">by the German computer magazine c't</a>
 */
public abstract class GameObject
        implements GameData
{
  // if you are interested which y coordinates are used change the "if (false)" line in contructor to "if (true)"
  private static int minY = Integer.MAX_VALUE;
  private static int maxY = Integer.MIN_VALUE;

  /** The x coordinate. */
  protected final int x;
  /** The y coordinate (y is point upwards). */
  protected final int y;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   */
  protected GameObject(int x, int y)
  {
    this.x = x;
    this.y = y;
    if (false) {
      if (y < minY) {
        minY = y;
        System.out.println("new min/max: "+minY+","+maxY);
      }
      if (y > maxY) {
        maxY = y;
        System.out.println("new min/max: "+minY+","+maxY);
      }
    }
  }

  /**
   *  Get the x coordinate of the objects center.
   *  @return center x
   */
  public int getX()
  {
    return x;
  }

  /**
   *  Get the y coordinate of the objects center.
   *  @return center y
   */
  public int getY()
  {
    return y;
  }

  /**
   *  Get the center of the object.
   *  @return center point
   */
  public Point getCenter()
  {
    return new Point(x, y);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public abstract int getSize();

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  public void draw(Graphics2D g)
  {
    g.setColor(Color.white);
    int size = getSize();
    g.drawOval(x - size, y - size, 2*size, 2*size);
  }

  /**
   *  Get the shortest vector from this to another game object.
   *
   *  Because of the torus topology it may be shorter going across the borders.
   *  @param obj other object
   *  @return shortest vector from this to the other object
   */
  public Point getDelta(GameObject obj)
  {
    int dx = obj.x - x;
    if (dx < -EXTENT_X/2) {
      dx += EXTENT_X;
    }
    else if (dx >= EXTENT_X/2) {
      dx -= EXTENT_X;
    }
    int dy = obj.y - y;
    if (dy < -EXTENT_Y/2) {
      dy += EXTENT_Y;
    }
    else if (dy >= EXTENT_Y/2) {
      dy -= EXTENT_Y;
    }
    return new Point(dx, dy);
  }

  /**
   *  Get the squared length of the shortest vector from this to another game object.
   *
   *  Because of the torus topology it may be shorter going across the borders.
   *  @param obj other object
   *  @return squared length of shortest vector from this to the other object
   */
  public int getSquaredDistance(GameObject obj)
  {
    int dx = obj.x - x;
    if (dx < -EXTENT_X/2) {
      dx += EXTENT_X;
    }
    else if (dx >= EXTENT_X/2) {
      dx -= EXTENT_X;
    }
    int dy = obj.y - y;
    if (dy < -EXTENT_Y/2) {
      dy += EXTENT_Y;
    }
    else if (dy >= EXTENT_Y/2) {
      dy -= EXTENT_Y;
    }
    return dx*dx + dy*dy;
  }

  /**
   *  Get the squared size of this object.
   *  @return squared size
   */
  public int getSquaredSize()
  {
    int size = getSize();
    return size*size;
  }
}
