/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class SimpleVelocityPreparer
implements FramePreparer {
    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() >= 2) {
            SpaceShip ship;
            FrameInfo lastFrame = frameInfos.getLast();
            FrameInfo prevFrame = frameInfos.get(frameInfos.size() - 2);
            Ufo ufo = lastFrame.getUfo();
            if (ufo != null) {
                ufo.setVelocityFromDelta(prevFrame.getUfo());
            }
            if ((ship = lastFrame.getSpaceShip()) != null) {
                ship.setVelocityFromDelta(prevFrame.getSpaceShip());
            }
            AsteroidSelector selector = new AsteroidSelector(lastFrame.getAsteroids());
            for (Asteroid ast : prevFrame.getAsteroids()) {
                Asteroid candidate = selector.getBestMatch(ast);
                if (candidate == null) continue;
                candidate.setVelocityFromDelta(ast);
            }
        }
    }

    private static class AsteroidSelector {
        private static final int MAX_SQUARED_DIST = 4096;
        private Map<Key, Collection<Asteroid>> sorted = new HashMap<Key, Collection<Asteroid>>();

        private AsteroidSelector(Collection<Asteroid> asteroids) {
            for (Asteroid ast : asteroids) {
                Key key = new Key(ast);
                Collection<Asteroid> list = this.sorted.get(key);
                if (list == null) {
                    list = new LinkedList<Asteroid>();
                    this.sorted.put(key, list);
                }
                list.add(ast);
            }
        }

        public Asteroid getBestMatch(Asteroid asteroid) {
            Key key = new Key(asteroid);
            Collection<Asteroid> list = this.sorted.get(key);
            TreeMap<Integer, Asteroid> result = new TreeMap<Integer, Asteroid>();
            if (list != null) {
                int futureX = asteroid.getX() + asteroid.getVelocityX();
                int futureY = asteroid.getY() + asteroid.getVelocityY();
                for (Asteroid a : list) {
                    int dist2 = a.getSquaredDistance(futureX, futureY);
                    if (dist2 >= 4096) continue;
                    result.put(dist2, a);
                }
            }
            return result.isEmpty() ? null : (Asteroid)result.values().iterator().next();
        }

        private static class Key {
            private final int type;
            private final int size;

            private Key(Asteroid ast) {
                this.type = ast.getType();
                this.size = ast.getSize();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.size != key.size) {
                    return false;
                }
                return this.type == key.type;
            }

            public int hashCode() {
                int result = this.type;
                result = 31 * result + this.size;
                return result;
            }
        }
    }
}

