// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.util.*;
import java.util.concurrent.LinkedBlockingQueue;


/**
 *  No just working.
 *
 * This class is part of a solution for a
 * <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class AsteroidPlayer
        implements Runnable,
                   FrameListener
{
  private LinkedList<FrameInfo> frames = new LinkedList<FrameInfo>();
  private LinkedBlockingQueue<FrameInfo> incomingFrames = new LinkedBlockingQueue<FrameInfo>();
  private Communication com;

  public AsteroidPlayer(Communication com)
  {
    this.com = com;
    com.setFramePreparer(new SimpleVelocityPreparer());
  }

  /**
   * Run in thread.
   * @see Thread#run()
   */
  public void run()
  {
    while (true) {
      try {
        FrameInfo info = incomingFrames.take();
        // todo: something cool ;-)
      } catch (InterruptedException e) {
        e.printStackTrace(System.err);
      }
    }
  }

  /**
   * Called each time a frame is received.
   * <p/>
   * <b>ATTENTION:</b> this is called from the communication thread!
   * Implementing classes must be aware of this and take care by synchronization or similar!
   *
   * @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    try {
      incomingFrames.put(frame);
    } catch (InterruptedException x) {
      x.printStackTrace(System.err);
    }
  }
}
