// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import de.caff.asteroid.server.Bridge;

import javax.swing.*;
import java.io.IOException;

/**
 *  Starter for automated player of Asteroids game.
 *
 *  It uses a thread for the communication.
 *  It can simulate the game display if run with switch <tt>-d</tt>.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class AsteroidPlayerRunner
{
  /** Default hostname (localhost). */
  public static final String DEFAULT_HOSTNAME = "127.0.0.1";
  /**
   * Start method.
   * @param args switch <tt>-d</tt> and/or hostname/ip address
   */
  public static void main(String[] args)
  {
    String hostname = DEFAULT_HOSTNAME;
    boolean withDisplay = false;
    boolean bridgeMode = false;
    int bridgePort = 0;
    boolean nextIsBridgePort = false;
    for (String arg: args) {
      if ("-d".equals(arg)) {
        withDisplay = true;
      }
      else if ("-b".equals(arg)) {
        bridgeMode = true;
        nextIsBridgePort = true;
      }
      else if (nextIsBridgePort) {
        nextIsBridgePort = false;
        try {
          bridgePort = Integer.parseInt(arg);
        } catch (NumberFormatException e) {
          System.err.println(String.format("Bridgemode -b requires numeric port, but has %s!", arg));
          System.exit(1);
        }
      }
      else {
        hostname = arg;
      }
    }
    if (nextIsBridgePort) {
      System.err.println("Bridgemode -b requires port number!");
      System.exit(1);
    }

    try {
      // start communication thread
      Communication com = new Communication(hostname);
      Thread comThread = new Thread(com, "Communication");
      comThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
        public void uncaughtException(Thread t, Throwable e)
        {
          System.err.println("Communication thread passed out.");
          e.printStackTrace(System.err);
          System.exit(1);
        }
      });
      comThread.start();

      if (withDisplay) {
        // add display
        JFrame frame = new JFrame("Frame Display");
        FrameDisplay display = new FrameDisplay(640);
        frame.getContentPane().add(display);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        com.addFrameListener(display);
      }

      if (bridgeMode) {
        // bridge mode (no player)
        Bridge bridge = new Bridge(bridgePort, com);
        Thread bridgeThread = new Thread(bridge, "Bridge");
        bridgeThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler()
        {
          public void uncaughtException(Thread t, Throwable e)
          {
            System.err.println("Bridge thread passed out.");
            e.printStackTrace(System.err);
            System.exit(1);
          }
        });
        bridgeThread.start();
        com.addDatagramListener(bridge);
      }
      else {
        // start player (should run in own thread)
        if (true) {
          // port from Harald Boegeholz
          SampleAsteroidPlayer player = new SampleAsteroidPlayer(com);
          com.addFrameListener(player);
        }
        else {
          // Rammi's stuff
          AsteroidPlayer player = new AsteroidPlayer(com);
          com.addFrameListener(player);
          Thread playerThread = new Thread(player, "Player");
          playerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler()
          {
            public void uncaughtException(Thread t, Throwable e)
            {
              System.err.println("Player thread passed out.");
              e.printStackTrace(System.err);
              System.exit(1);
            }
          });
          playerThread.start();

        }
      }
    } catch (IOException e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}
