// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;

/**
 * Bullet object in automated player of Asteroids game.
 *
 * Bullets are either shot by the ship or by an ufo.
 *
 * This class is part of a solution for a
 * <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class Bullet
        extends GameObject
{

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   */
  public Bullet(int x, int y)
  {
    super(x, y);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return 0;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  public void draw(Graphics2D g)
  {
    g.setColor(Color.white);
    g.fillOval(x-1, y-1, 3, 3);
  }

}
