// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.util.LinkedList;

/**
 *  Called by {@link de.caff.asteroid.Communication} before a frame is distributed to
 *  {@link de.caff.asteroid.FrameListener}s.
 *  Called each time a frame is added to the internal queue.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public interface FramePreparer
{
  /**
   *  Prepare the frame(s).
   *  @param frameInfos the collected frame infos
   */
  void prepareFrames(LinkedList<FrameInfo> frameInfos);
}
