// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Some useful constants of the Asteroids game.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public interface GameData
{
  /** Size of the vector ram. */
  int VECTORRAM_SIZE = 1024;
  /** Extent of x and y coordinates. */
  int EXTENT = 1024;
  /** Border above and below y because of 4/3 screen aspect ratio. */
  int BORDER_Y = EXTENT/8;
  /** The minimal y coordinate used. */
  int MIN_Y = BORDER_Y;
  /** The screen extend in x direction. */
  int EXTENT_X = EXTENT;
  /** The screen extent in y direction. */
  int EXTENT_Y = EXTENT - 2*BORDER_Y;
  /** The maximal y coordinate used. */
  int MAX_Y = BORDER_Y + EXTENT_Y - 1;
  /** Hyperspace button pressed. */
  int BUTTON_HYPERSPACE = 0x01;
  /** Fire button pressed. */
  int BUTTON_FIRE       = 0x01 << 1;
  /** Thrust button pressed. */
  int BUTTON_THRUST     = 0x01 << 2;
  /** Left button pressed. */
  int BUTTON_RIGHT      = 0x01 << 3;
  /** Right button pressed. */
  int BUTTON_LEFT       = 0x01 << 4;
  /** Port used by mame. */
  int MAME_PORT = 1979;
}
