// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

/**
 * Space ship in automated player of Asteroid game.
 *
 * This is part of a solution for a competition
 * <a href="http://www.heise.de/ct/creativ/08/02/details/">by the German computer magazine c't</a>
 */
public class SpaceShip
        extends GameObject
{
  /** Ship color. */
  private static final Color COLOR = new Color(0xc0, 0xc0, 0xc0); // not as white as bullets

  /** The ship shape for drawing. */
  private static final GeneralPath SHIP_SHAPE = new GeneralPath();
  static {
    // defined for 0 angle
    SHIP_SHAPE.moveTo(16, 0);
    SHIP_SHAPE.lineTo(-16, 8);
    SHIP_SHAPE.lineTo(-8, 0);
    SHIP_SHAPE.lineTo(-16, -8);
    SHIP_SHAPE.closePath();
  }

  /** The direction of the ship, x coordinate. */
  private final int dx;
  /** The direction of the ship, y coordinate. */
  private final int dy;

  /**
   *  Constructor.
   *  @param x  x coordinate of ship center
   *  @param y  y coordinate of ship center
   *  @param dx direction x
   *  @param dy direction y
   */
  public SpaceShip(int x, int y, int dx, int dy)
  {
    super(x, y);
    this.dx = dx;
    this.dy = dy;
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return 16;
  }

  /**
   *  Get the x coordinate of the ship's direction.
   *  @return ship direction, x coordinate
   */
  public int getDirX()
  {
    return dx;
  }

  /**
   *  Get the y coordinate of the ship's direction.
   *  @return ship direction, y coordinate
   */
  public int getDirY()
  {
    return dy;
  }

  /**
   *  Get the direction angle.
   *
   *  The angle is measured counterclockwise, with <code>0</code> pointing to the right
   *  @return ship direction in radians
   */
  public double getDirectionAngle()
  {
    return Math.atan2(dy, dx);
  }

  /**
   * Draw the object.
   *
   * @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    g.setColor(COLOR);
    AffineTransform at = AffineTransform.getTranslateInstance(x, y);
    at.concatenate(AffineTransform.getRotateInstance(getDirectionAngle()));
    g.fill(at.createTransformedShape(SHIP_SHAPE));

    drawVelocityVector(g);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("SpaceShip@(%d,%d)>(%.1f)", x, y, 180*getDirectionAngle()/Math.PI);
  }
}
