// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial products
//                     is not allowed without explicite permission.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision$
 */
public class Ufo
        extends GameObject
{
  /** Shape used for big ufo. */
  private static final GeneralPath BIG = new GeneralPath();
  /** Shape used for small ufo. */
  private static final GeneralPath SMALL;
  static {
    int w = 24;
    int h = 8;
    BIG.moveTo(-w,  0);
    BIG.lineTo( w,  0);
    BIG.lineTo( w/2, -h);
    BIG.lineTo(-w/2, -h);
    BIG.lineTo(-w,  0);
    BIG.lineTo(-w/2, h);
    BIG.lineTo( w/2, h);
    BIG.lineTo( w,  0);
    BIG.moveTo( -h, h);
    BIG.lineTo( -2*h/3, 2*h);
    BIG.lineTo(  2*h/3, 2*h);
    BIG.lineTo(  h, h);

    SMALL = new GeneralPath(BIG);
    SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
  }

  /** Is this ufo big? */
  private final boolean big;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   *  @param size incoming size from MAME
   */
  public Ufo(int x, int y, int size)
  {
    super(x, y);
    this.big = (size == 15);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return big ? 16 : 8;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    g.setColor(Color.white);
    g.draw(AffineTransform.getTranslateInstance(x, y).createTransformedShape(big ? BIG : SMALL));

    drawVelocityVector(g);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Ufo@(%d,%d)*%d", x, y, getSize());
  }
}

