/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.AsteroidPlayer;
import de.caff.asteroid.AutoStarter;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameDisplay;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.SampleAsteroidPlayer;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.StupidPlayer;
import de.caff.asteroid.server.Bridge;
import java.io.IOException;
import javax.swing.JFrame;

public class AsteroidPlayerRunner {
    public static final String DEFAULT_HOSTNAME = "127.0.0.1";

    public static void main(String[] args) {
        String hostname = DEFAULT_HOSTNAME;
        boolean withDisplay = false;
        boolean bridgeMode = false;
        int bridgePort = 0;
        boolean nextIsBridgePort = false;
        for (String arg : args) {
            if ("-d".equals(arg)) {
                withDisplay = true;
                continue;
            }
            if ("-b".equals(arg)) {
                bridgeMode = true;
                nextIsBridgePort = true;
                continue;
            }
            if (nextIsBridgePort) {
                nextIsBridgePort = false;
                try {
                    bridgePort = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    System.err.println(String.format("Bridgemode -b requires numeric port, but has %s!", arg));
                    System.exit(1);
                }
                continue;
            }
            hostname = arg;
        }
        if (nextIsBridgePort) {
            System.err.println("Bridgemode -b requires port number!");
            System.exit(1);
        }
        try {
            Communication com = new Communication(hostname, bridgeMode);
            Thread comThread = new Thread((Runnable)com, "Communication");
            comThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    System.err.println("Communication thread passed out.");
                    e.printStackTrace(System.err);
                    System.exit(1);
                }
            });
            comThread.start();
            if (withDisplay) {
                JFrame frame = new JFrame(bridgeMode ? "Bridge Display" : "Frame Display");
                FrameDisplay display = new FrameDisplay(640);
                frame.getContentPane().add(display);
                frame.pack();
                frame.setVisible(true);
                frame.setDefaultCloseOperation(3);
                com.addFrameListener(display);
            }
            if (bridgeMode) {
                Bridge bridge = new Bridge(bridgePort, com);
                Thread bridgeThread = new Thread((Runnable)bridge, "Bridge");
                bridgeThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println("Bridge thread passed out.");
                        e.printStackTrace(System.err);
                        System.exit(1);
                    }
                });
                bridgeThread.start();
                com.addDatagramListener(bridge);
                com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new SimpleVelocityPreparer(), new ScoreFixer()}));
            } else {
                AutoStarter.install(com);
                switch (0) {
                    case 0: {
                        SampleAsteroidPlayer player = new SampleAsteroidPlayer(com);
                        com.addFrameListener(player);
                        break;
                    }
                    case 1: {
                        AsteroidPlayer player = new AsteroidPlayer(com);
                        com.addFrameListener(player);
                        Thread playerThread = new Thread((Runnable)player, "Player");
                        playerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                            @Override
                            public void uncaughtException(Thread t, Throwable e) {
                                System.err.println("Player thread passed out.");
                                e.printStackTrace(System.err);
                                System.exit(1);
                            }
                        });
                        playerThread.start();
                        break;
                    }
                    case 2: {
                        StupidPlayer player = new StupidPlayer(com);
                        com.addFrameListener(player);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

