// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

/**
 *  The ufo object.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Ufo
        extends SizedGameObject
{
  /** Shape used for big ufo. */
  private static final GeneralPath BIG = new GeneralPath();
  /** Shape used for small ufo. */
  private static final GeneralPath SMALL;
  static {
    int w = 24;
    int h = 8;
    BIG.moveTo(-w,  0);
    BIG.lineTo( w,  0);
    BIG.lineTo( w/2, -h);
    BIG.lineTo(-w/2, -h);
    BIG.lineTo(-w,  0);
    BIG.lineTo(-w/2, h);
    BIG.lineTo( w/2, h);
    BIG.lineTo( w,  0);
    BIG.moveTo( -h, h);
    BIG.lineTo( -2*h/3, 2*h);
    BIG.lineTo(  2*h/3, 2*h);
    BIG.lineTo(  h, h);

    SMALL = new GeneralPath(BIG);
    SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
  }

  /** Is this ufo big? */
  private final boolean big;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   *  @param size incoming size from MAME
   */
  public Ufo(int x, int y, int size)
  {
    super(x, y);
    this.big = (size == 15);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return big ? 16 : 8;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    g.setColor(Color.white);
    g.draw(AffineTransform.getTranslateInstance(x, y).createTransformedShape(big ? BIG : SMALL));

    drawVelocityVector(g, Color.red);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Ufo@(%d,%d)*%d", x, y, getSize());
  }

  private static int minVX = 0;
  private static int maxVX = 0;
  private static int minVY = 0;
  private static int maxVY = 0;
  private static int maxVSquared   = 0;

  /**
   * Set the velocity.
   * <p/>
   * The velocity is the step between frames.
   *
   * @param x x coordinate of velocity
   * @param y y coordinate of velocity
   */
  @Override
  public void setVelocity(int x, int y)
  {
    super.setVelocity(x, y);
    if (WATCH_VELOCITIES) {
      boolean print = false;
      if (x < minVX) {
        minVX = x;
        print = true;
      }
      else if (x > maxVX) {
        maxVX = x;
        print = true;
      }
      if (y < minVY) {
        minVY = y;
        print = true;
      }
      else if (y > maxVY) {
        maxVY = y;
        print = true;
      }
      int len2 = x*x + y*y;
      if (len2 > maxVSquared) {
        maxVSquared = len2;
        print = true;
      }
      if (print) {
        System.out.println(String.format("UFO: minV=(%d,%d), maxV=(%d,%d), maxV^2=%d",
                                         minVX, minVY, maxVX, maxVY, maxVSquared));
      }
    }
  }
}

