/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Explosion;
import de.caff.asteroid.GameData;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import de.caff.asteroid.Ufo;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FrameInfo
implements GameData {
    private static final Map<Integer, Character> CHAR_MAP = new HashMap<Integer, Character>();
    public static final String GAME_END_STRING;
    public static final String GAME_START_STRING;
    public static final String PLAYER1_STRING;
    private static final int NO_NUMBER = -1;
    static final int MAME_DATAGRAM_SIZE = 1026;
    private static final int ID_BYTE = 1024;
    private static final int PING_BYTE = 1025;
    private static final int MASK_OPCODE = 240;
    private static final int OPCODE_LABS = 160;
    private static final int OPCODE_HALT = 176;
    private static final int OPCODE_JSRL = 192;
    private static final int OPCODE_RTSL = 208;
    private static final int OPCODE_JMPL = 224;
    private static final int OPCODE_SVEC = 240;
    private static final int OPCODE_SHIP = 96;
    private static final int SUB_ASTEROID_TYPE1 = 2291;
    private static final int SUB_ASTEROID_TYPE2 = 2303;
    private static final int SUB_ASTEROID_TYPE3 = 2317;
    private static final int SUB_ASTEROID_TYPE4 = 2330;
    private static final int SUB_UFO = 2345;
    private static final int SUB_SHIP = 2669;
    private static final int SUB_EXPLOSION_XXL = 2176;
    private static final int SUB_EXPLOSION_XL = 2198;
    private static final int SUB_EXPLOSION_L = 2229;
    private static final int SUB_EXPLOSION_S = 2256;
    private final byte id;
    private final byte ping;
    private Ufo ufo;
    private List<Asteroid> asteroids = new LinkedList<Asteroid>();
    private SpaceShip spaceShip;
    private List<Bullet> bullets = new LinkedList<Bullet>();
    private List<Explosion> explosions = new LinkedList<Explosion>();
    private final long receiveTime;
    private final long pingTime;
    private int score = -1;
    private int highscore = -1;
    private int sonirt = -1;
    private boolean gameStartDisplayed;
    private boolean player1Displayed;
    private boolean gameEndDisplayed;
    private int nrShips;
    private List<Text> texts = new LinkedList<Text>();

    private static int byteToUnsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    FrameInfo(byte[] bytes, long[] pingTimes) throws IOException {
        if (bytes.length != 1026) {
            throw new IOException("Incorrect datagram with size " + bytes.length);
        }
        if ((bytes[1] & 0xF0) != 224) {
            throw new IOException(String.format("Incorrect vector buffer start: %02x%02x", bytes[0], bytes[1]));
        }
        this.receiveTime = System.currentTimeMillis();
        this.id = bytes[1024];
        this.ping = bytes[1025];
        this.pingTime = this.ping != 0 ? this.receiveTime - pingTimes[FrameInfo.byteToUnsigned(this.ping)] : 0L;
        int vx = 0;
        int vy = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int dx = 0;
        int dy = 0;
        int tx = 0;
        int ty = 0;
        boolean possibleShip = false;
        StringBuilder stringCollect = new StringBuilder();
        int p = 2;
        while (p < 1024) {
            boolean addedLetter = false;
            int highbyte = FrameInfo.byteToUnsigned(bytes[p + 1]);
            int opcode = highbyte & 0xF0;
            switch (opcode) {
                case 160: {
                    vy = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                    highbyte = FrameInfo.byteToUnsigned(bytes[(p += 2) + 1]);
                    vx = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                    vs = highbyte >> 4;
                    p += 2;
                    break;
                }
                case 176: {
                    return;
                }
                case 192: {
                    int sub = (highbyte & 0xF) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                    switch (sub) {
                        case 2291: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 0));
                            break;
                        }
                        case 2303: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 1));
                            break;
                        }
                        case 2317: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 2));
                            break;
                        }
                        case 2330: {
                            this.asteroids.add(new Asteroid(vx, vy, vs, 3));
                            break;
                        }
                        case 2345: {
                            this.ufo = new Ufo(vx, vy, vs);
                            break;
                        }
                        case 2176: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.XXL));
                            break;
                        }
                        case 2198: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.XL));
                            break;
                        }
                        case 2229: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.L));
                            break;
                        }
                        case 2256: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.S));
                            break;
                        }
                        case 2669: {
                            ++this.nrShips;
                        }
                        default: {
                            Character ch = CHAR_MAP.get(sub);
                            if (ch == null) break;
                            stringCollect.append(ch);
                            if (addedLetter) break;
                            addedLetter = true;
                            tx = vx;
                            ty = vy;
                        }
                    }
                    p += 2;
                    break;
                }
                case 208: {
                    return;
                }
                case 224: {
                    return;
                }
                case 240: {
                    p += 2;
                    break;
                }
                default: {
                    if (this.spaceShip == null) {
                        dy = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                        if ((highbyte & 4) != 0) {
                            dy = -dy;
                        }
                        highbyte = FrameInfo.byteToUnsigned(bytes[(p += 2) + 1]);
                        dx = (highbyte & 3) << 8 | FrameInfo.byteToUnsigned(bytes[p]);
                        if ((highbyte & 4) != 0) {
                            dx = -dx;
                        }
                        int vz = highbyte >> 4;
                        if (dx == 0 && dy == 0 && vz == 15) {
                            this.bullets.add(new Bullet(vx, vy));
                        }
                        if (dx != 0 && dy != 0) {
                            if (opcode == 96 && vz == 12) {
                                if (possibleShip) {
                                    if (this.spaceShip == null) {
                                        this.spaceShip = new SpaceShip(vx, vy, v1x - dx, v1y - dy);
                                    }
                                    possibleShip = false;
                                } else {
                                    v1x = dx;
                                    v1y = dy;
                                    possibleShip = true;
                                }
                            }
                        } else if (possibleShip) {
                            possibleShip = false;
                        }
                        p += 2;
                        break;
                    }
                    p += 4;
                }
            }
            if (addedLetter || stringCollect.length() <= 0) continue;
            String str = stringCollect.toString();
            this.texts.add(new Text(str, tx, ty));
            stringCollect.setLength(0);
            if (tx == FrameInfo.SCORE_LOCATION_GAME.x && ty == FrameInfo.SCORE_LOCATION_GAME.y || tx == FrameInfo.SCORE_LOCATION_OTHER.x && ty == FrameInfo.SCORE_LOCATION_OTHER.y) {
                this.score = FrameInfo.extractNumber(str);
                continue;
            }
            if (tx == FrameInfo.HIGHSCORE_LOCATION.x && ty == FrameInfo.HIGHSCORE_LOCATION.y) {
                this.highscore = FrameInfo.extractNumber(str);
                continue;
            }
            if (tx == FrameInfo.SONIRT_LOCATION.x && ty == FrameInfo.SONIRT_LOCATION.y) {
                this.sonirt = FrameInfo.extractNumber(str);
                continue;
            }
            if (GAME_END_STRING.equals(str)) {
                this.gameEndDisplayed = true;
                continue;
            }
            if (GAME_START_STRING.equals(str)) {
                this.gameStartDisplayed = true;
                continue;
            }
            if (!PLAYER1_STRING.equals(str)) continue;
            this.player1Displayed = true;
        }
    }

    private static int extractNumber(String str) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }

    public void draw(Graphics2D g) {
        for (Asteroid asteroid : this.asteroids) {
            asteroid.draw(g);
        }
        if (this.ufo != null) {
            this.ufo.draw(g);
        }
        if (this.spaceShip != null) {
            this.spaceShip.draw(g);
        }
        for (Bullet bullet : this.bullets) {
            bullet.draw(g);
        }
        for (Explosion explode : this.explosions) {
            explode.draw(g);
        }
    }

    public byte getId() {
        return this.id;
    }

    public int getPing() {
        return this.ping;
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public Ufo getUfo() {
        return this.ufo;
    }

    public int getAsteroidCount() {
        return this.asteroids.size();
    }

    public int getBulletCount() {
        return this.bullets.size();
    }

    public int getTargetCount() {
        return this.ufo != null ? this.getAsteroidCount() + 1 : this.getAsteroidCount();
    }

    public Collection<Asteroid> getAsteroids() {
        return Collections.unmodifiableCollection(this.asteroids);
    }

    public SpaceShip getSpaceShip() {
        return this.spaceShip;
    }

    public Collection<Bullet> getBullets() {
        return Collections.unmodifiableCollection(this.bullets);
    }

    public Collection<Explosion> getExplosions() {
        return Collections.unmodifiableCollection(this.explosions);
    }

    public int getHighscore() {
        return this.highscore;
    }

    public void setHighscore(int highscore) {
        this.highscore = highscore;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getSonirt() {
        return this.sonirt;
    }

    public boolean isGameRunning() {
        return this.sonirt == -1;
    }

    public int getNrShips() {
        return this.nrShips;
    }

    public boolean isGameStartDisplayed() {
        return this.gameStartDisplayed;
    }

    public boolean isGameEndDisplayed() {
        return this.gameEndDisplayed;
    }

    public boolean isPlayer1Displayed() {
        return this.player1Displayed;
    }

    public Collection<Text> getTexts() {
        return Collections.unmodifiableCollection(this.texts);
    }

    public static String canonize(String str) {
        str = str.toUpperCase();
        StringBuilder result = new StringBuilder();
        for (char ch : str.toCharArray()) {
            if (ch == 'O') {
                result.append('0');
                continue;
            }
            if (CHAR_MAP.values().contains(Character.valueOf(ch))) {
                result.append(ch);
                continue;
            }
            result.append(' ');
        }
        return result.toString();
    }

    static {
        CHAR_MAP.put(2680, Character.valueOf('A'));
        CHAR_MAP.put(2688, Character.valueOf('B'));
        CHAR_MAP.put(2701, Character.valueOf('C'));
        CHAR_MAP.put(2707, Character.valueOf('D'));
        CHAR_MAP.put(2715, Character.valueOf('E'));
        CHAR_MAP.put(2723, Character.valueOf('F'));
        CHAR_MAP.put(2730, Character.valueOf('G'));
        CHAR_MAP.put(2739, Character.valueOf('H'));
        CHAR_MAP.put(2746, Character.valueOf('I'));
        CHAR_MAP.put(2753, Character.valueOf('J'));
        CHAR_MAP.put(2759, Character.valueOf('K'));
        CHAR_MAP.put(2765, Character.valueOf('L'));
        CHAR_MAP.put(2770, Character.valueOf('M'));
        CHAR_MAP.put(2776, Character.valueOf('N'));
        CHAR_MAP.put(2781, Character.valueOf('0'));
        CHAR_MAP.put(2787, Character.valueOf('P'));
        CHAR_MAP.put(2794, Character.valueOf('Q'));
        CHAR_MAP.put(2803, Character.valueOf('R'));
        CHAR_MAP.put(2811, Character.valueOf('S'));
        CHAR_MAP.put(2818, Character.valueOf('T'));
        CHAR_MAP.put(2824, Character.valueOf('U'));
        CHAR_MAP.put(2830, Character.valueOf('V'));
        CHAR_MAP.put(2835, Character.valueOf('W'));
        CHAR_MAP.put(2842, Character.valueOf('X'));
        CHAR_MAP.put(2847, Character.valueOf('Y'));
        CHAR_MAP.put(2854, Character.valueOf('Z'));
        CHAR_MAP.put(2860, Character.valueOf(' '));
        CHAR_MAP.put(2862, Character.valueOf('1'));
        CHAR_MAP.put(2866, Character.valueOf('2'));
        CHAR_MAP.put(2874, Character.valueOf('3'));
        CHAR_MAP.put(2881, Character.valueOf('4'));
        CHAR_MAP.put(2888, Character.valueOf('5'));
        CHAR_MAP.put(2895, Character.valueOf('6'));
        CHAR_MAP.put(2902, Character.valueOf('7'));
        CHAR_MAP.put(2907, Character.valueOf('8'));
        CHAR_MAP.put(2915, Character.valueOf('9'));
        GAME_END_STRING = FrameInfo.canonize("SPIELENDE");
        GAME_START_STRING = FrameInfo.canonize("STARTKN0EPFE DRUECKEN");
        PLAYER1_STRING = FrameInfo.canonize("SPIELER 1");
    }
}

