// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

/**
 *  Explosion in the game.
 *
 *  Please note that this currently only exists to display something.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Explosion
        extends SizedGameObject
{
  /** SHape to display. */
  private static final GeneralPath SHAPE = new GeneralPath();
  static {
    SHAPE.moveTo(1.0, 0.6);
    SHAPE.curveTo(0.7, 0.6, 0.6, 0.7, 0.6, 1.0);
    SHAPE.moveTo(0.5, 1.0);
    SHAPE.curveTo(0.3, 0.9, -0.3, 0.9, -0.5, 1.0);
    SHAPE.append(SHAPE.createTransformedShape(AffineTransform.getRotateInstance(Math.PI/2)), false);
    SHAPE.append(SHAPE.createTransformedShape(AffineTransform.getRotateInstance(Math.PI)), false);
  }

  /** The different explosion types. */
  static enum Type {
    XXL(32),
    XL(24),
    L(16),
    S(8);

    int size;
    Type(int size)
    {
      this.size = size;
    }
  }
  /** Type of explosion. */
  private Type type;
  /** Scale of explosion (inverse). */
  private int scale;

  /**
   *  Constructor.
   *  @param x   center x
   *  @param y   center y
   *  @param scale  scale from MAME
   *  @param type   type of explosion
   */
  public Explosion(int x, int y, int scale, Type type)
  {
    super(x, y);
    this.type = type;
    switch (scale) {
    case 0:
      this.scale = 1;
      break;

    case 15:
      this.scale = 2;
      break;

    case 14:
      this.scale = 4;
      break;

    case 13:
      this.scale = 8;
      break;

    case 12:
      this.scale = 16;
      break;

    case 11:
      this.scale = 32;
      break;

    default:
      System.out.println("Unexpected explosion scaling: "+scale);
      this.scale = 1;
    }
  }

  /**
   *  Get the type.
   *  @return type
   */
  public Type getType()
  {
    return type;
  }

  /**
   * Get the size of the object.
   * <p/>
   * The size returned by this method is half the length of a square which contains the object,
   * so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *
   * @return object size
   */
  public int getSize()
  {
    return type.size/scale;
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Explosion(%s)@(%d,%d)*%d", type, x, y, getSize());
  }

  /**
   * Draw the object.
   *
   * @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    Graphics2D g2 = (Graphics2D)g.create(); // copy to change stroke
    g2.setColor(Color.red);
    //g2.setStroke(new BasicStroke(type.size/8/scale));
    AffineTransform trafo = new AffineTransform(type.size/scale, 0, 0, type.size/scale, x, y);
    g2.draw(trafo.createTransformedShape(SHAPE));
  }
}