// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Generic game object in Asteroid game.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class GameObject
        implements GameData
{
  /** The x coordinate. */
  protected final int x;
  /** The y coordinate (y is point upwards). */
  protected final int y;

  /**
   *  Constructor.
   *  @param x x coordinate
   *  @param y y coordinate (points upwards in game)
   */
  public GameObject(int x, int y)
  {
    this.x = x;
    this.y = y;
  }

  /**
   *  Get the x coordinate of the objects center.
   *  @return center x
   */
  public int getX()
  {
    return x;
  }

  /**
   *  Get the y coordinate of the objects center.
   *  @return center y
   */
  public int getY()
  {
    return y;
  }

  /**
   *  Get the squared length of the shortest vector from this to another game object.
   *
   *  Because of the torus topology it may be shorter going across the borders.
   *  @param obj other object
   *  @return squared length of shortest vector from this to the other object
   */
  public int getSquaredDistance(GameObject obj)
  {
    return getSquaredDistance(obj.getX(), obj.getY());
  }

  /**
   *  Get the squared length of the shortest vector from this objects position to another position.
   *
   *  Because of the torus topology it may be shorter going across the borders.
   *  @param px other position's x
   *  @param py other position's y
   *  @return squared length of shortest vector from this object to the other position
   */
  public int getSquaredDistance(int px, int py)
  {
    int dx = px - x;
    if (dx < -EXTENT_X/2) {
      dx += EXTENT_X;
    }
    else if (dx >= EXTENT_X/2) {
      dx -= EXTENT_X;
    }
    int dy = py - y;
    if (dy < -EXTENT_Y/2) {
      dy += EXTENT_Y;
    }
    else if (dy >= EXTENT_Y/2) {
      dy -= EXTENT_Y;
    }
    return dx*dx + dy*dy;
  }
}
