// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;

/**
 *  A text (or number) displayed on screen.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Text
        extends GameObject
{
  /** The text. */
  private final String text;

  /**
   *  Constructor.
   *  @param text text
   *  @param x    positon x
   *  @param y    postion y
   */
  public Text(String text, int x, int y)
  {
    super(x, y);
    this.text = text;
  }

  /**
   *  Get the displayed text.
   *  Take care that all text are only uppercase and use 0 (zero) instead of O (oh).
   *  @return text
   */
  public String getText()
  {
    return text;
  }

  /**
   *  Get the location of the text.
   *  @return text location
   */
  public Point getLocation()
  {
    return new Point(x, y);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Text(%s)@(%d,%d)", text, x, y);
  }

  /**
   *  Has this text a given location?
   *  @param px x coordinate
   *  @param py y coordinate
   *  @return <code>true</code> if this text is at the given location,
   *          <code>false</code> otherwise
   */
  public boolean hasLocation(int px, int py)
  {
    return px == x  &&  py == y;
  }

  /**
   *  Has this text a given location?
   *  @param p location
   *  @return <code>true</code> if this text is at the given location,
   *          <code>false</code> otherwise
   */
  public boolean hasLocation(Point p)
  {
    return hasLocation(p.x, p.y);
  }

}
