/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public abstract class MovingGameObject
extends GameObject {
    protected static final boolean WATCH_VELOCITIES = false;
    private static int minY = Integer.MAX_VALUE;
    private static int maxY = Integer.MIN_VALUE;
    private static final int ARROW_HEAD_SIZE = 8;
    private static final GeneralPath ARROW_HEAD = new GeneralPath();
    private int vx;
    private int vy;

    protected MovingGameObject(int x, int y) {
        super(x, y);
    }

    public Point getCenter() {
        return new Point(this.x, this.y);
    }

    public abstract int getSize();

    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        int size = this.getSize();
        g.drawOval(this.x - size, this.y - size, 2 * size, 2 * size);
        this.drawVelocityVector(g, Color.red);
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }

    public void setVelocity(int x, int y) {
        this.vx = x;
        this.vy = y;
    }

    public void setVelocity(Point v) {
        this.setVelocity(v.x, v.y);
    }

    public void setVelocityFromDelta(MovingGameObject obj) {
        if (obj != null) {
            this.setVelocity(obj.getDelta(this));
        }
    }

    public int getVelocityX() {
        return this.vx;
    }

    public int getVelocityY() {
        return this.vy;
    }

    public Point getVelocity() {
        return new Point(this.vx, this.vy);
    }

    public double getVelocityAngle() {
        return this.vx != 0 || this.vy != 0 ? Math.atan2(this.vy, this.vx) : -Math.PI;
    }

    public boolean hasKnownVelocity() {
        return this.vx != 0 || this.vy != 0;
    }

    protected void drawVelocityVector(Graphics2D g, Color color) {
        if (this.vx != 0 || this.vy != 0) {
            int scale = 16;
            g.setColor(color);
            g.drawLine(this.x, this.y, this.x + scale * this.vx, this.y + scale * this.vy);
            double angle = Math.atan2(this.vy, this.vx);
            AffineTransform at = AffineTransform.getTranslateInstance(this.x + scale * this.vx, this.y + scale * this.vy);
            at.concatenate(AffineTransform.getRotateInstance(angle));
            g.fill(at.createTransformedShape(ARROW_HEAD));
        }
    }

    @Override
    public Rectangle getBounds() {
        Point center = this.getCenter();
        int size = this.getSize();
        return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
    }

    public Point getNextLocation() {
        return new Point(this.getX() + this.getVelocityX(), this.getY() + this.getVelocityY());
    }

    public Point getPredictedLocation(int nrFrames) {
        return new Point(this.getX() + nrFrames * this.getVelocityX(), this.getY() + nrFrames * this.getVelocityY());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("Size", this.getSize()));
        props.add(new Property<Rectangle>("Bounds", this.getBounds()));
        props.add(new Property<Point>("Velocity", this.getVelocity()));
        return props;
    }

    static {
        ARROW_HEAD.moveTo(0.0f, 0.0f);
        ARROW_HEAD.lineTo(-8.0f, 8.0f);
        ARROW_HEAD.lineTo(-8.0f, -8.0f);
        ARROW_HEAD.closePath();
    }
}

