/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class SimpleVelocityPreparer
implements FramePreparer {
    private static final int MAX_SQUARED_ASTEROID_VELOCITY = 36;
    private static final int MAX_SQUARED_BULLET_VELOCITY = 256;

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        block9: {
            block8: {
                SpaceShip ship;
                if (frameInfos.size() < 2) break block8;
                FrameInfo lastFrame = frameInfos.getLast();
                FrameInfo prevFrame = frameInfos.get(frameInfos.size() - 2);
                Ufo ufo = lastFrame.getUfo();
                if (ufo != null) {
                    ufo.setVelocityFromDelta(prevFrame.getUfo());
                }
                if ((ship = lastFrame.getSpaceShip()) != null) {
                    ship.setVelocityFromDelta(prevFrame.getSpaceShip());
                }
                AsteroidSelector selector = new AsteroidSelector(lastFrame.getAsteroids());
                for (Asteroid ast : prevFrame.getAsteroids()) {
                    Asteroid candidate = selector.getBestMatch(ast);
                    if (candidate == null) continue;
                    candidate.setVelocityFromDelta(ast);
                }
                for (Bullet oldBullet : prevFrame.getBullets()) {
                    int futureX = oldBullet.getX() + oldBullet.getVelocityX();
                    int futureY = oldBullet.getY() + oldBullet.getVelocityY();
                    TreeMap<Integer, Pair<Bullet>> result = new TreeMap<Integer, Pair<Bullet>>();
                    for (Bullet bullet : lastFrame.getBullets()) {
                        int dist2 = bullet.getSquaredDistance(futureX, futureY);
                        if (dist2 >= 256) continue;
                        result.put(dist2, new Pair<Bullet>(oldBullet, bullet));
                    }
                    LinkedList pairs = new LinkedList(result.values());
                    while (!pairs.isEmpty()) {
                        Pair pair = (Pair)pairs.remove(0);
                        ((Bullet)pair.second).setVelocityFromDelta((MovingGameObject)pair.first);
                        ((Bullet)pair.second).setLifetime(((Bullet)pair.first).getLifetime() + 1);
                        ListIterator it = pairs.listIterator();
                        while (it.hasNext()) {
                            Pair p = (Pair)it.next();
                            if (!((Bullet)p.first).equals(pair.first) && !((Bullet)p.second).equals(pair.second)) continue;
                            it.remove();
                        }
                    }
                }
                break block9;
            }
            if (frameInfos.size() <= 1) break block9;
            for (Bullet bullet : frameInfos.getLast().getBullets()) {
                bullet.setLifetime(1);
            }
        }
    }

    private static class AsteroidSelector {
        private Map<Key, Collection<Asteroid>> sorted = new HashMap<Key, Collection<Asteroid>>();

        private AsteroidSelector(Collection<Asteroid> asteroids) {
            for (Asteroid ast : asteroids) {
                Key key = new Key(ast);
                Collection<Asteroid> list = this.sorted.get(key);
                if (list == null) {
                    list = new LinkedList<Asteroid>();
                    this.sorted.put(key, list);
                }
                list.add(ast);
            }
        }

        public Asteroid getBestMatch(Asteroid asteroid) {
            Key key = new Key(asteroid);
            Collection<Asteroid> list = this.sorted.get(key);
            TreeMap<Integer, Asteroid> result = new TreeMap<Integer, Asteroid>();
            if (list != null) {
                int futureX = asteroid.getX() + asteroid.getVelocityX();
                int futureY = asteroid.getY() + asteroid.getVelocityY();
                for (Asteroid a : list) {
                    int dist2 = a.getSquaredDistance(futureX, futureY);
                    if (dist2 >= 36) continue;
                    result.put(dist2, a);
                }
            }
            return result.isEmpty() ? null : (Asteroid)result.values().iterator().next();
        }

        private static class Key {
            private final int type;
            private final int size;

            private Key(Asteroid ast) {
                this.type = ast.getType();
                this.size = ast.getSize();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.size != key.size) {
                    return false;
                }
                return this.type == key.type;
            }

            public int hashCode() {
                int result = this.type;
                result = 31 * result + this.size;
                return result;
            }
        }
    }
}

