/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.analysis.DumpFileChangeListener;
import de.caff.asteroid.analysis.FileFormat;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.util.Tools;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DumpFile
implements FileFormat {
    private List<FrameKeyInfo> infos = new ArrayList<FrameKeyInfo>();
    private List<Mark> marks = new ArrayList<Mark>();
    private IOException finalException;
    private List<DumpFileChangeListener> changeListeners = new LinkedList<DumpFileChangeListener>();

    public DumpFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream is = new BufferedInputStream(fis);
        byte[] intro = new byte[INTRO.length];
        if (is.read(intro) < intro.length) {
            throw new IOException(String.format("%s: too short!", filename));
        }
        for (int i = 0; i < intro.length; ++i) {
            if (intro[i] == INTRO[i]) continue;
            throw new IOException(String.format("%s: intro error at %d!", filename, i));
        }
        byte[] frame = new byte[1026];
        long[] pingTimes = new long[256];
        MarkType markType = null;
        try {
            int nextByte;
            FrameKeyInfo info = null;
            while ((nextByte = is.read()) >= 0) {
                switch (nextByte) {
                    case 79: {
                        long timestamp = DumpFile.readTimestamp(is);
                        int bytesRead = is.read(frame, 0, 8);
                        if (bytesRead < 8) {
                            throw new IOException(String.format("%s: premature EOF!", filename));
                        }
                        DumpFile.checkKeyPacket(frame);
                        if (info != null) {
                            info.addButtons(timestamp, frame[KEY_MASK_INDEX], frame[KEY_PING_INDEX]);
                        } else {
                            System.out.println(String.format("%s: keys before first frame: %s!", filename, new Buttons(frame[KEY_MASK_INDEX])));
                        }
                        pingTimes[Tools.byteToUnsigned((byte)frame[DumpFile.KEY_PING_INDEX])] = timestamp;
                        break;
                    }
                    case 73: {
                        long timestamp = DumpFile.readTimestamp(is);
                        int bytesRead = is.read(frame);
                        if (bytesRead < 1026) {
                            throw new IOException(String.format("%s: premature EOF!", filename));
                        }
                        info = new FrameKeyInfo(timestamp, frame, pingTimes);
                        MarkType newMarkType = DumpFile.getFrameType(info);
                        if (newMarkType != markType) {
                            this.marks.add(new Mark(this.infos.size(), newMarkType));
                            markType = newMarkType;
                        }
                        this.infos.add(info);
                    }
                }
            }
        }
        catch (IOException e) {
            this.finalException = e;
            e.printStackTrace();
        }
        this.runPreparer(new ScoreFixer());
    }

    private static long readTimestamp(InputStream is) throws IOException {
        long result = 0L;
        for (int b = 0; b < 8; ++b) {
            int bb = is.read();
            if (bb < 0) {
                throw new IOException("Premature EOF!");
            }
            result |= (long)(bb & 0xFF) << 8 * b;
        }
        return result;
    }

    private static void checkKeyPacket(byte[] keyPacket) throws IOException {
        for (int i = KEY_PACKET_INTRO.length - 1; i >= 0; --i) {
            if (keyPacket[i] == KEY_PACKET_INTRO[i]) continue;
            throw new IOException("Invalid key packet!");
        }
    }

    private static MarkType getFrameType(FrameKeyInfo info) {
        return info.getFrameInfo().isGameRunning() ? MarkType.GAME_START : MarkType.GAME_END;
    }

    public List<FrameKeyInfo> getInfos() {
        return this.infos;
    }

    public List<Mark> getMarks() {
        return this.marks;
    }

    public IOException getFinalException() {
        return this.finalException;
    }

    public void runPreparer(final FramePreparer preparer) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DumpFile.this.runPrep(preparer);
            }
        }).start();
    }

    private synchronized void runPrep(FramePreparer preparer) {
        LinkedList<FrameInfo> pending = new LinkedList<FrameInfo>();
        for (FrameKeyInfo info : this.infos) {
            pending.add(info.getFrameInfo());
            if (pending.size() > 256) {
                pending.remove(0);
            }
            preparer.prepareFrames(pending);
        }
        this.informDumpFileChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDumpFileChangeListener(DumpFileChangeListener listener) {
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDumpFileChangeListener(DumpFileChangeListener listener) {
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            return this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDumpFileChangeListeners() {
        ArrayList<DumpFileChangeListener> tmp;
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<DumpFileChangeListener>(this.changeListeners);
        }
        for (DumpFileChangeListener listener : tmp) {
            listener.dumpFileChange();
        }
    }

    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            DumpFile file = new DumpFile(arg);
            System.out.println(String.format("%s: %d frames and %d marks.", arg, file.getInfos().size(), file.getMarks().size()));
        }
    }

    public static class Mark {
        private int frameIndex;
        private MarkType markType;

        public Mark(int frameIndex, MarkType markType) {
            this.frameIndex = frameIndex;
            this.markType = markType;
        }

        public int getFrameIndex() {
            return this.frameIndex;
        }

        public MarkType getMarkType() {
            return this.markType;
        }
    }

    public static enum MarkType {
        GAME_START,
        GAME_END;

    }
}

