// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util;

import java.awt.*;

/**
 *  Useful static helper methods.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Tools
{
  /**
   * Interprete 8 bits as unsigned byte.
   * @param b incomoing byte
   * @return unsigned interpretation
   */
  public static int byteToUnsigned(byte b)
  {
    return b < 0 ? b + 256 : b;
  }

  /**
   *  Get the cross product of two vectors,
   *  @param v1 first vector
   *  @param v2 second vector
   *  @return v1 x v2
   */
  public static int crossProduct(Point v1, Point v2)
  {
    return v1.x * v2.y - v1.y * v2.x;
  }

  /**
   *  Get the scalar product of two vectors.
   *  @param v1 first vector
   *  @param v2 second vector
   *  @return scalar product
   */
  public static int scalarProduct(Point v1, Point v2)
  {
    return v1.x * v2.x + v1.y * v2.y;
  }

  /**
   *  Get the manhattan distance between two points.
   *  The manhattan distance is the sum of the distances in x and y.
   *  @param p1 first point
   *  @param p2 second point
   *  @return manhattan distance
   */
  public static int getManhattanDistance(Point p1, Point p2)
  {
    return Math.abs(p1.x - p2.x) + Math.abs(p1.y - p2.y);
  }
}
