/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.GameData;
import de.caff.asteroid.server.DatagramListener;
import de.caff.asteroid.server.DatagramSender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Communication
implements Runnable,
GameData,
DatagramSender {
    public static final int MAX_FRAMES_KEPT = 256;
    private DatagramSocket socket;
    private LinkedList<FrameInfo> pendingFrames = new LinkedList();
    private byte[] keyFrame = new byte[8];
    private DatagramPacket keyDatagram;
    private DatagramPacket mameDatagram;
    private List<FrameListener> frameListeners;
    private List<DatagramListener> datagramListeners;
    private int ping;
    private int latestPing;
    private long[] pingTimes;
    private InetSocketAddress mameAddr;
    private FramePreparer framePreparer;
    private Buttons buttons;
    private boolean bridgeMode;

    public Communication(String hostname, boolean bridgeMode) throws IOException {
        System.arraycopy(KEY_PACKET_INTRO, 0, this.keyFrame, 0, KEY_PACKET_INTRO.length);
        this.keyDatagram = new DatagramPacket(this.keyFrame, this.keyFrame.length);
        this.mameDatagram = new DatagramPacket(new byte[1026], 1026);
        this.frameListeners = new LinkedList<FrameListener>();
        this.datagramListeners = new LinkedList<DatagramListener>();
        this.ping = 1;
        this.latestPing = 0;
        this.pingTimes = new long[256];
        this.buttons = new Buttons();
        this.bridgeMode = bridgeMode;
        int port = 1979;
        String[] parts = hostname.split(":");
        if (parts.length == 2) {
            try {
                port = Integer.parseInt(parts[1]);
                hostname = parts[0];
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.socket = new DatagramSocket();
        this.mameAddr = new InetSocketAddress(hostname, port);
        this.socket.connect(this.mameAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (!this.bridgeMode) {
                    this.sendKeys();
                }
                this.socket.receive(this.mameDatagram);
                long receiveTime = System.currentTimeMillis();
                this.informDatagramListeners(this.mameDatagram);
                FrameInfo fi = new FrameInfo(this.mameDatagram.getData(), this.pingTimes, receiveTime);
                LinkedList<FrameInfo> linkedList = this.pendingFrames;
                synchronized (linkedList) {
                    if (!this.pendingFrames.isEmpty()) {
                        if (this.pendingFrames.size() >= 256) {
                            this.pendingFrames.removeFirst();
                        }
                        byte lastId = this.pendingFrames.getLast().getId();
                        byte id = fi.getId();
                        if ((byte)(id - lastId) != 1) {
                            System.err.println("Frame dropped? last=" + lastId + ", current=" + id);
                        }
                        if (this.framePreparer != null) {
                            this.framePreparer.prepareFrames(this.pendingFrames);
                        }
                    }
                    this.pendingFrames.add(fi);
                    if (this.framePreparer != null) {
                        this.framePreparer.prepareFrames(this.pendingFrames);
                    }
                }
                this.informFrameListeners(fi);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeys() throws IOException {
        DatagramPacket datagramPacket = this.keyDatagram;
        synchronized (datagramPacket) {
            this.keyFrame[Communication.KEY_MASK_INDEX] = this.buttons.extractKeys();
            this.keyFrame[Communication.KEY_PING_INDEX] = (byte)this.ping;
            this.keyDatagram.setData(this.keyFrame);
            this.pingTimes[this.ping] = System.currentTimeMillis();
            this.socket.send(this.keyDatagram);
            this.informDatagramListeners(this.keyDatagram);
            this.latestPing = this.ping++;
            if (this.ping >= 256) {
                this.ping = 1;
            }
        }
    }

    public void setButton(int button, boolean down) {
        this.buttons.setKey(button, down);
    }

    public void pushButton(int button) {
        this.setButton(button, true);
    }

    public byte getButtons() {
        return this.buttons.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameListener(FrameListener listener) {
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            this.frameListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFrameListener(FrameListener listener) {
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            return this.frameListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatagramListener(DatagramListener listener) {
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            this.datagramListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDatagramListener(DatagramListener listener) {
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            return this.datagramListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informFrameListeners(FrameInfo frameInfo) {
        ArrayList<FrameListener> tmp;
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            if (this.frameListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<FrameListener>(this.frameListeners);
        }
        for (FrameListener listener : tmp) {
            listener.frameReceived(frameInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDatagramListeners(DatagramPacket datagram) {
        ArrayList<DatagramListener> tmp;
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            if (this.datagramListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<DatagramListener>(this.datagramListeners);
        }
        for (DatagramListener listener : tmp) {
            listener.datagramReceived(datagram, this);
        }
    }

    @Override
    public void sendDatagram(DatagramPacket packet) throws IOException {
        packet.setSocketAddress(this.mameAddr);
        this.socket.send(packet);
        this.informDatagramListeners(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FrameInfo> getFrames() {
        LinkedList<FrameInfo> linkedList = this.pendingFrames;
        synchronized (linkedList) {
            return new ArrayList<FrameInfo>(this.pendingFrames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FrameInfo> getFramesAfter(long timestamp) {
        FrameInfo info;
        ArrayList<FrameInfo> tmpFrames;
        LinkedList<FrameInfo> linkedList = this.pendingFrames;
        synchronized (linkedList) {
            if (this.pendingFrames.isEmpty() || this.pendingFrames.getFirst().getReceiveTime() > timestamp) {
                return this.getFrames();
            }
            tmpFrames = new ArrayList<FrameInfo>(this.pendingFrames);
        }
        LinkedList<FrameInfo> result = new LinkedList<FrameInfo>();
        for (int f = tmpFrames.size() - 1; f >= 0 && (info = tmpFrames.remove(f)).getReceiveTime() > timestamp; --f) {
            result.add(0, info);
        }
        return result;
    }

    public FramePreparer getFramePreparer() {
        return this.framePreparer;
    }

    public void setFramePreparer(FramePreparer framePreparer) {
        this.framePreparer = framePreparer;
    }

    public int getLatestPing() {
        return this.latestPing;
    }
}

