/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.awt.Point;

public class SampleAsteroidPlayer
implements FrameListener,
GameData {
    private boolean shot;
    private Communication com;

    public SampleAsteroidPlayer(Communication com) {
        this.com = com;
        com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new SimpleVelocityPreparer(), new ScoreFixer()}));
        com.addFrameListener(new HallOfFameFiller(com, "bo"));
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        SpaceShip ship;
        if (frame != null && (ship = frame.getSpaceShip()) != null) {
            MovingGameObject target = SampleAsteroidPlayer.findNearestTarget(ship, frame);
            if (target == null) {
                if (frame.getTargetCount() > 0) {
                    this.com.pushButton(4);
                }
            } else {
                Point delta = ship.getDelta(target);
                int dist2 = delta.x * delta.x + delta.y * delta.y;
                if (dist2 < 961) {
                    this.com.pushButton(1);
                } else if (ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0) {
                    this.com.pushButton(16);
                } else {
                    this.com.pushButton(8);
                }
            }
            this.com.setButton(2, this.shot);
            this.shot = !this.shot;
        }
    }

    private static MovingGameObject findNearestTarget(SpaceShip ship, FrameInfo info) {
        int dist2;
        MovingGameObject nearest = null;
        int minDist2 = 160000;
        for (Asteroid ast : info.getAsteroids()) {
            int dist22 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
            if (dist22 >= minDist2) continue;
            minDist2 = dist22;
            nearest = ast;
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize()) < minDist2) {
            nearest = ufo;
        }
        return nearest;
    }
}

