/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;

public class AnalysisDisplay
extends JFrame {
    public AnalysisDisplay(final String filename, FramePreparer velocityPreparer) throws IOException {
        super("Analysis of " + filename);
        DumpFile dumpFile = new DumpFile(filename);
        final TimeLine timeLine = new TimeLine(dumpFile);
        FrameKeyInfoDisplay frameKeyInfoDisplay = new FrameKeyInfoDisplay(timeLine, velocityPreparer, AnalysisDisplay.getDrawableProvider());
        timeLine.addFrameListener(new FrameListener(){

            @Override
            public void frameReceived(FrameInfo frame) {
                AnalysisDisplay.this.setTitle(String.format("%s [%d]", filename, timeLine.getCurrentIndex()));
            }
        });
        this.getContentPane().add((Component)frameKeyInfoDisplay, "Center");
        this.getContentPane().add((Component)timeLine, "South");
        this.setSize(1200, 800);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Need dump file argument!");
            System.exit(1);
        }
        AnalysisDisplay dpy = new AnalysisDisplay(args[0], AnalysisDisplay.getBestPreparer());
        dpy.setDefaultCloseOperation(3);
        dpy.setVisible(true);
    }

    private static FramePreparer getBestPreparer() {
        try {
            Class<?> clazz = Class.forName("de.caff.asteroid.rammi.ImprovedVelocityPreparer");
            return (FramePreparer)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new SimpleVelocityPreparer();
    }

    private static DrawableProvider getDrawableProvider() {
        try {
            Class<?> clazz = Class.forName("de.caff.asteroid.rammi.AsteroidPlayer");
            return (DrawableProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }
}

