/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ButtonBar
extends JToolBar {
    private static final String MEDIA_BUTTON_ICON_LOCATION = "/toolbarButtonGraphics/media/";
    private static final String MEDIA_BUTTON_ICON_EXTENSION = "16.gif";
    private static final int SLEEP_DURATION = 10;
    private AbstractAction playAction;
    private boolean running;

    private static Icon getIcon(String iconName) {
        return new ImageIcon(ButtonBar.class.getResource(MEDIA_BUTTON_ICON_LOCATION + iconName + MEDIA_BUTTON_ICON_EXTENSION));
    }

    public ButtonBar(final TimeLine timeLine, final FramePreparer velocityPreparer) {
        this.add(new AbstractAction("Step back", ButtonBar.getIcon("StepBack")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpFile.Mark marker = timeLine.getPreviousMarker(timeLine.getCurrentIndex());
                if (marker != null) {
                    timeLine.setCurrentIndex(marker.getFrameIndex());
                }
            }
        });
        this.add(new AbstractAction("Frame back", ButtonBar.getIcon("Rewind")){

            @Override
            public void actionPerformed(ActionEvent e) {
                timeLine.setCurrentIndex(timeLine.getCurrentIndex() - 1);
            }
        });
        this.addSeparator();
        this.playAction = new AbstractAction("Play", ButtonBar.getIcon("Play")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonBar.this.toggleRunning(timeLine);
            }
        };
        this.add(this.playAction);
        this.addSeparator();
        this.add(new AbstractAction("Frame forward", ButtonBar.getIcon("FastForward")){

            @Override
            public void actionPerformed(ActionEvent e) {
                timeLine.setCurrentIndex(timeLine.getCurrentIndex() + 1);
            }
        });
        this.add(new AbstractAction("Step forward", ButtonBar.getIcon("StepForward")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpFile.Mark marker = timeLine.getNextMarker(timeLine.getCurrentIndex());
                if (marker != null) {
                    timeLine.setCurrentIndex(marker.getFrameIndex());
                }
            }
        });
        this.addSeparator(new Dimension(16, 16));
        final JCheckBox arrows = new JCheckBox("Velocities", false);
        this.add(arrows);
        arrows.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (arrows.isSelected()) {
                    timeLine.getDumpFile().runPreparer(velocityPreparer);
                } else {
                    timeLine.getDumpFile().runPreparer(new FramePreparer(){

                        @Override
                        public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
                            FrameInfo last = frameInfos.getLast();
                            for (MovingGameObject mgo : last.getMovingGameObjects()) {
                                mgo.setVelocity(0.0, 0.0);
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleRunning(final TimeLine timeLine) {
        AbstractAction abstractAction = this.playAction;
        synchronized (abstractAction) {
            if (this.running) {
                this.running = false;
                this.playAction.putValue("SmallIcon", ButtonBar.getIcon("Play"));
            } else {
                this.running = true;
                this.playAction.putValue("SmallIcon", ButtonBar.getIcon("Stop"));
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            AbstractAction abstractAction = ButtonBar.this.playAction;
                            synchronized (abstractAction) {
                                if (!ButtonBar.this.running) {
                                    return;
                                }
                            }
                            final int current = timeLine.getCurrentIndex();
                            if (current + 1 == timeLine.getFrameCount()) {
                                ButtonBar.this.toggleRunning(timeLine);
                            }
                            if (current >= 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        timeLine.setCurrentIndex(current + 1);
                                    }
                                });
                            } else {
                                ButtonBar.this.toggleRunning(timeLine);
                            }
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                });
                thread.start();
            }
        }
    }
}

