/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class TimeLine
extends JComponent {
    private static final int BORDER_Y = 8;
    private static final int BORDER_X = 6;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color IN_GAME_COLOR = Color.blue;
    private static final Color BETWEEN_GAMES_COLOR = Color.orange;
    private static final Color MARKER_COLOR = Color.black;
    private DumpFile dumpFile;
    private int currentIndex = 0;
    private List<FrameListener> frameListeners = new LinkedList<FrameListener>();

    public TimeLine(DumpFile dumpFile) {
        this.dumpFile = dumpFile;
        this.setMinimumSize(new Dimension(100, 32));
        this.setPreferredSize(this.getMinimumSize());
        this.setOpaque(true);
        this.currentIndex = dumpFile.getInfos().isEmpty() ? -1 : 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TimeLine.this.setCurrentFrom(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TimeLine.this.setCurrentFrom(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                TimeLine.this.setCurrentIndex(TimeLine.this.getCurrentIndex() - e.getWheelRotation());
            }
        });
    }

    private void setCurrentFrom(MouseEvent e) {
        int index = this.getIndexAt(e.getPoint());
        if (index >= 0) {
            DumpFile.Mark mark = this.getNearestMarker(index);
            int screenX = this.indexToScreen(mark.getFrameIndex());
            if (Math.abs(screenX - e.getX()) < 2) {
                index = mark.getFrameIndex();
            }
            this.setCurrentIndex(index);
        }
    }

    public void setCurrentIndex(int frameIndex) {
        if (this.hasFrames()) {
            if (frameIndex < 0) {
                frameIndex = 0;
            } else if (frameIndex >= this.dumpFile.getInfos().size()) {
                frameIndex = this.dumpFile.getInfos().size() - 1;
            }
            if (frameIndex != this.currentIndex) {
                this.currentIndex = frameIndex;
                this.informFrameListeners(this.dumpFile.getInfos().get(frameIndex).getFrameInfo());
                this.repaint();
            }
        }
    }

    public boolean hasFrames() {
        return !this.dumpFile.getInfos().isEmpty();
    }

    public int getIndexAt(Point p) {
        return this.isValid() ? this.screenToIndex(p.x) : -1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public FrameKeyInfo getCurrentInfo() {
        return this.hasFrames() ? this.dumpFile.getInfos().get(this.getCurrentIndex()) : null;
    }

    public DumpFile.Mark getNearestMarker(int index) {
        DumpFile.Mark nearest = null;
        if (this.hasFrames()) {
            int minDistance = Integer.MAX_VALUE;
            for (DumpFile.Mark mark : this.dumpFile.getMarks()) {
                int dist = Math.abs(mark.getFrameIndex() - index);
                if (dist < minDistance) {
                    minDistance = dist;
                    nearest = mark;
                    continue;
                }
                if (dist <= minDistance) continue;
                break;
            }
        }
        return nearest;
    }

    public DumpFile.Mark getNextMarker(int index) {
        DumpFile.Mark next = null;
        if (this.hasFrames()) {
            for (DumpFile.Mark mark : this.dumpFile.getMarks()) {
                if (mark.getFrameIndex() <= index) continue;
                next = mark;
                break;
            }
        }
        return next;
    }

    public DumpFile.Mark getPreviousMarker(int index) {
        DumpFile.Mark prev = null;
        if (this.hasFrames()) {
            DumpFile.Mark last = null;
            for (DumpFile.Mark mark : this.dumpFile.getMarks()) {
                if (mark.getFrameIndex() >= index) {
                    prev = last;
                    break;
                }
                last = mark;
            }
        }
        return prev;
    }

    public DumpFile getDumpFile() {
        return this.dumpFile;
    }

    private int screenToIndex(int screenX) {
        return this.isValid() ? (int)((double)(screenX - 6) / this.getScale()) : -1;
    }

    private int indexToScreen(int index) {
        return this.isValid() ? (int)((double)index * this.getScale() + 6.0) : -1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        DumpFile.Mark prevMark = null;
        for (DumpFile.Mark mark : this.dumpFile.getMarks()) {
            if (prevMark != null) {
                int left = this.indexToScreen(prevMark.getFrameIndex());
                int right = this.indexToScreen(mark.getFrameIndex());
                g.setColor(prevMark.getMarkType() == DumpFile.MarkType.GAME_START ? IN_GAME_COLOR : BETWEEN_GAMES_COLOR);
                g.fillRect(left, 8, right - left, this.getHeight() - 16);
            }
            prevMark = mark;
        }
        if (prevMark != null) {
            Graphics2D g2 = (Graphics2D)g;
            int left = this.indexToScreen(prevMark.getFrameIndex());
            int right = this.indexToScreen(this.dumpFile.getInfos().size());
            g.setColor(prevMark.getMarkType() == DumpFile.MarkType.GAME_START ? IN_GAME_COLOR : BETWEEN_GAMES_COLOR);
            g.fillRect(left, 8, right - left, this.getHeight() - 16);
            g.setColor(MARKER_COLOR);
            int markerPos = this.indexToScreen(this.currentIndex);
            g.drawLine(markerPos, 0, markerPos, this.getHeight());
            GeneralPath triangles = new GeneralPath();
            triangles.moveTo(markerPos, 8.0f);
            triangles.lineTo(markerPos + 4, 1.0f);
            triangles.lineTo(markerPos - 4, 1.0f);
            triangles.closePath();
            int y = this.getHeight() - 1;
            triangles.moveTo(markerPos, y - 8);
            triangles.lineTo(markerPos + 4, y);
            triangles.lineTo(markerPos - 4, y);
            triangles.closePath();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fill(triangles);
        }
    }

    private double getScale() {
        int size = this.dumpFile.getInfos().size();
        return size > 0 ? (double)(this.getWidth() - 12) / (double)size : -1.0;
    }

    public void addFrameListener(FrameListener listener) {
        this.frameListeners.add(listener);
    }

    public boolean removeFrameListener(FrameListener listener) {
        return this.frameListeners.remove(listener);
    }

    private void informFrameListeners(FrameInfo frameInfo) {
        for (FrameListener listener : this.frameListeners) {
            listener.frameReceived(frameInfo);
        }
    }

    public int getFrameCount() {
        return this.dumpFile.getInfos().size();
    }

    public int getSessionTime(int frameIndex) {
        if (this.hasFrames()) {
            DumpFile.Mark prevMarker = this.getPreviousMarker(frameIndex);
            while (prevMarker != null) {
                if (prevMarker.getMarkType() == DumpFile.MarkType.GAME_START) {
                    return (int)(this.dumpFile.getInfos().get(frameIndex).getFrameInfo().getReceiveTime() - this.dumpFile.getInfos().get(prevMarker.getFrameIndex()).getFrameInfo().getReceiveTime());
                }
                prevMarker = this.getPreviousMarker(prevMarker.getFrameIndex());
            }
            return (int)(this.dumpFile.getInfos().get(frameIndex).getFrameInfo().getReceiveTime() - this.dumpFile.getInfos().get(0).getFrameInfo().getReceiveTime());
        }
        return 0;
    }

    public int getCurrentSessionTime() {
        return this.getSessionTime(this.getCurrentIndex());
    }
}

