/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Tools {
    public static int byteToUnsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static int crossProduct(Point v1, Point v2) {
        return v1.x * v2.y - v1.y * v2.x;
    }

    public static double crossProduct(Point2D v1, Point2D v2) {
        return v1.getX() * v2.getY() - v1.getY() * v2.getX();
    }

    public static int crossProduct(int v1x, int v1y, int v2x, int v2y) {
        return v1x * v2y - v1y * v2x;
    }

    public static double crossProduct(double v1x, double v1y, double v2x, double v2y) {
        return v1x * v2y - v1y * v2x;
    }

    public static int scalarProduct(Point v1, Point v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static int scalarProduct(int v1x, int v1y, int v2x, int v2y) {
        return v1x * v2x + v1y * v2y;
    }

    public static double scalarProduct(double v1x, double v1y, double v2x, double v2y) {
        return v1x * v2x + v1y * v2y;
    }

    public static double getLength(Point v) {
        return Math.sqrt(v.x * v.x + v.y * v.y);
    }

    public static double getLength(Point2D v) {
        double x = v.getX();
        double y = v.getY();
        return Math.sqrt(x * x + y * y);
    }

    public static Point2D normalize(Point2D v) {
        double y;
        double x = v.getX();
        double len = Math.sqrt(x * x + (y = v.getY()) * y);
        return len > 0.0 ? new Point2D.Double(x / len, y / len) : null;
    }

    public static int getManhattanDistance(Point p1, Point p2) {
        return Tools.getManhattanDistance(p1.x, p1.y, p2.x, p2.y);
    }

    public static int getManhattanDistance(int p1x, int p1y, int p2x, int p2y) {
        return Math.abs(p1x - p2x) + Math.abs(p1y - p2y);
    }

    public static double square(double v) {
        return v * v;
    }
}

