// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

/**
 *  The ufo object.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Ufo
        extends MovingGameObject
{
  /** Shape used for big ufo. */
  private static final GeneralPath BIG = new GeneralPath();
  /** Shape used for small ufo. */
  private static final GeneralPath SMALL;
  static {
    int w = 24;
    int h = 8;
    BIG.moveTo(-w,  0);
    BIG.lineTo( w,  0);
    BIG.lineTo( w/2, -h);
    BIG.lineTo(-w/2, -h);
    BIG.lineTo(-w,  0);
    BIG.lineTo(-w/2, h);
    BIG.lineTo( w/2, h);
    BIG.lineTo( w,  0);
    BIG.moveTo( -h, h);
    BIG.lineTo( -2*h/3, 2*h);
    BIG.lineTo(  2*h/3, 2*h);
    BIG.lineTo(  h, h);

    SMALL = new GeneralPath(BIG);
    SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
  }

  /** Is this ufo big? */
  private final boolean big;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   *  @param size incoming size from MAME
   */
  public Ufo(int x, int y, int size)
  {
    super(x, y);
    this.big = (size == 15);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return big ? 16 : 8;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    g.setColor(Color.white);
    g.draw(AffineTransform.getTranslateInstance(x, y).createTransformedShape(big ? BIG : SMALL));

    drawVelocityVector(g, Color.red);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Ufo@(%d,%d)*%d", x, y, getSize());
  }

  /**
   * Get the properties of this object.
   *
   * @return collection of properties
   */
  @Override
  public Collection<Property> getProperties()
  {
    Collection<Property> props = super.getProperties();
    props.add(new Property<String>("Ufo Size", big ? "BIG" : "small"));
    return props;
  }

  /**
   * Get the type of game object.
   *
   * @return game object type
   */
  public String getObjectType()
  {
    return "Ufo";
  }


  /**
   * Get the score which is added if this object is hit.
   *
   * @return score or {@link #NO_SCORE}
   */
  @Override
  public int getScore()
  {
    return big ? 200 : 1000;
  }
}

