// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import de.caff.asteroid.*;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;

/**
 *  Visual analyser tool for tool for dump files.
 * 
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class AnalysisDisplay
        extends JFrame
{
  /**
   *  Constructor.
   *  @param filename name of file to analyse
   *  @param velocityPreparer preparer used to add velocities to game objects
   *  @throws java.io.IOException on file format or read errors
   */
  public AnalysisDisplay(final String filename, FramePreparer velocityPreparer) throws IOException
  {
    super("Analysis of "+filename);
    DumpFile dumpFile = new DumpFile(filename);

    final TimeLine timeLine = new TimeLine(dumpFile);
    FrameKeyInfoDisplay frameKeyInfoDisplay = new FrameKeyInfoDisplay(timeLine, velocityPreparer, getDrawableProvider());

    timeLine.addFrameListener(new FrameListener()
    {
      public void frameReceived(FrameInfo frame)
      {
        setTitle(String.format("%s [%d]", filename, timeLine.getCurrentIndex()));
      }
    });
    getContentPane().add(frameKeyInfoDisplay, BorderLayout.CENTER);
    getContentPane().add(timeLine, BorderLayout.SOUTH);
    setSize(1200, 800);
  }

  /**
   *  Start analysis of dump file.
   *  @param args exactly one argument is necessary: the dumpfile path
   *  @throws IOException on early read errors (if the file is missing or the format is incorrect, but
   *                      not if later errors occur like a premature EOF after several frames)
   */
  public static void main(String[] args) throws IOException
  {
    if (args.length == 0) {
      System.err.println("Need dump file argument!");
      System.exit(1);
    }
    AnalysisDisplay dpy = new AnalysisDisplay(args[0], getBestPreparer());
    dpy.setDefaultCloseOperation(AnalysisDisplay.EXIT_ON_CLOSE);
    dpy.setVisible(true);
  }

  private static FramePreparer getBestPreparer()
  {
    try {
      Class clazz = Class.forName("de.caff.asteroid.rammi.ImprovedVelocityPreparer");
      return (FramePreparer)clazz.newInstance();
    } catch (ClassNotFoundException e) {
    } catch (InstantiationException e) {
    } catch (IllegalAccessException e) {
    }
    return new SimpleVelocityPreparer();
  }

  private static DrawableProvider getDrawableProvider()
  {
    try {
      Class clazz = Class.forName("de.caff.asteroid.rammi.AsteroidPlayer");
      return (DrawableProvider)clazz.newInstance();
    } catch (ClassNotFoundException e) {
    } catch (InstantiationException e) {
    } catch (IllegalAccessException e) {
    }
    return null;
  }
}
