// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import de.caff.asteroid.*;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.*;
import java.util.LinkedList;

/**
 *  Some buttons to go forward and backward and start replaying.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class ButtonBar
        extends JToolBar
{
  /** The location of the Java Look&Feel graphics icons, download via
   *  <a href="http://java.sun.com/developer/techDocs/hi/repository/">this repository</a>.
   */
  private static final String MEDIA_BUTTON_ICON_LOCATION = "/toolbarButtonGraphics/media/";

  private static final String MEDIA_BUTTON_ICON_EXTENSION = "16.gif";

  private static final int SLEEP_DURATION = 10;

  private static Icon getIcon(String iconName)
  {
    return new ImageIcon(ButtonBar.class.getResource(MEDIA_BUTTON_ICON_LOCATION + iconName + MEDIA_BUTTON_ICON_EXTENSION));
  }

  private AbstractAction playAction;
  private boolean running;

  public ButtonBar(final TimeLine timeLine, final FramePreparer velocityPreparer)
  {
    add(new AbstractAction("Step back", getIcon("StepBack")) {
      public void actionPerformed(ActionEvent e)
      {
        DumpFile.Mark marker = timeLine.getPreviousMarker(timeLine.getCurrentIndex());
        if (marker != null) {
          timeLine.setCurrentIndex(marker.getFrameIndex());
        }
      }
    });
    add(new AbstractAction("Frame back", getIcon("Rewind")) {
      public void actionPerformed(ActionEvent e)
      {
        timeLine.setCurrentIndex(timeLine.getCurrentIndex() - 1);
      }
    });
    addSeparator();

    playAction = new AbstractAction("Play", getIcon("Play"))
    {
      public void actionPerformed(ActionEvent e)
      {
        toggleRunning(timeLine);
      }
    };
    add(playAction);
    addSeparator();

    add(new AbstractAction("Frame forward", getIcon("FastForward")) {
      public void actionPerformed(ActionEvent e)
      {
        timeLine.setCurrentIndex(timeLine.getCurrentIndex() + 1);
      }
    });
    add(new AbstractAction("Step forward", getIcon("StepForward")) {
      public void actionPerformed(ActionEvent e)
      {
        DumpFile.Mark marker = timeLine.getNextMarker(timeLine.getCurrentIndex());
        if (marker != null) {
          timeLine.setCurrentIndex(marker.getFrameIndex());
        }
      }
    });

    addSeparator(new Dimension(16, 16));
    final JCheckBox arrows = new JCheckBox("Velocities", false);
    add(arrows);
    arrows.addItemListener(new ItemListener()
    {
      public void itemStateChanged(ItemEvent e)
      {
        if (arrows.isSelected()) {
          timeLine.getDumpFile().runPreparer(velocityPreparer);
        }
        else {
          // remove all velocities
          timeLine.getDumpFile().runPreparer(new FramePreparer()
          {
            public void prepareFrames(LinkedList<FrameInfo> frameInfos)
            {
              FrameInfo last = frameInfos.getLast();
              for (MovingGameObject mgo: last.getMovingGameObjects()) {
                mgo.setVelocity(0, 0);
              }
            }
          });
        }
      }
    });
  }

  private void toggleRunning(final TimeLine timeLine)
  {
    synchronized (playAction) {
      if (running) {
        running = false;
        playAction.putValue(Action.SMALL_ICON, getIcon("Play"));
      }
      else {
        running = true;
        playAction.putValue(Action.SMALL_ICON, getIcon("Stop"));
        Thread thread = new Thread(new Runnable() {
          public void run()
          {
            while (true) {
              synchronized (playAction) {
                if (!running) {
                  return;
                }
              }
              final int current = timeLine.getCurrentIndex();
              if (current+1 == timeLine.getFrameCount()) {
                toggleRunning(timeLine);
              }
              if (current >= 0) {
                SwingUtilities.invokeLater(new Runnable() {
                  public void run()
                  {
                    timeLine.setCurrentIndex(current + 1);
                  }
                });
              }
              else {
                toggleRunning(timeLine);
              }
              try {
                Thread.sleep(SLEEP_DURATION);
              } catch (InterruptedException e) {
                e.printStackTrace();
              }
            }
          }
        });
        thread.start();
      }
    }
  }
}
