/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameDisplay
extends JComponent
implements FrameListener,
GameData {
    private static final Color TIME_COLOR = new Color(0, 255, 0, 128);
    private static final Color SCORE_COLOR = new Color(255, 255, 255, 128);
    private static final Point PENDING_SHIPS_POSITION = new Point(160, 852);
    private static final int PENDING_SHIPS_DELTA_X = 20;
    private int baseWidth;
    private FrameInfo frameInfo;
    private AffineTransform trafo;
    private DrawableProvider drawableProvider;
    private long startTime = -1L;

    public FrameDisplay(int width) {
        this.baseWidth = width;
        if (width > 0) {
            Dimension size = new Dimension(width, 3 * width / 4);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setSize(size);
            this.calculateScaling();
        } else {
            this.setMinimumSize(new Dimension(200, 150));
            this.setPreferredSize(new Dimension(640, 480));
        }
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    private void calculateScaling() {
        int width = this.baseWidth <= 0 ? Math.min(this.getWidth(), 4 * this.getHeight() / 3) : this.baseWidth;
        double scaling = (double)width / 1024.0;
        this.trafo = AffineTransform.getTranslateInstance(0.0, -896.0);
        this.trafo.preConcatenate(AffineTransform.getScaleInstance(scaling, -scaling));
    }

    private Dimension getCorrectSize() {
        int width = this.baseWidth <= 0 ? Math.min(this.getWidth(), 4 * this.getHeight() / 3) : this.baseWidth;
        return new Dimension(width, 3 * width / 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        FrameInfo info;
        if (this.baseWidth == 0) {
            this.calculateScaling();
        }
        g.setColor(Color.black);
        Dimension size = this.getCorrectSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setClip(0, 0, size.width, size.height);
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            info = this.frameInfo;
        }
        if (info != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            Text.setFontRenderContext(((Graphics2D)g).getFontRenderContext());
            g2.transform(this.trafo);
            info.draw(g2);
            if (this.drawableProvider != null) {
                this.drawableProvider.draw(g2, info);
            }
            g2.setColor(Color.gray);
            for (int s = info.getNrShips() - 1; s >= 0; --s) {
                g2.draw(SpaceShip.getShipShape(FrameDisplay.PENDING_SHIPS_POSITION.x + s * 20, FrameDisplay.PENDING_SHIPS_POSITION.y, 1.5707963267948966));
            }
            Point pos = new Point();
            if (!info.isGameRunning()) {
                g.setColor(new Color(255, 255, 0, 128));
                Point2D.Double pos0 = new Point2D.Double(0.0, 0.0);
                Point2D.Double pos1 = new Point2D.Double(0.0, 1.0);
                this.trafo.transform(pos0, pos0);
                this.trafo.transform(pos1, pos1);
                float fontScale = (float)Math.abs(((Point2D)pos0).getY() - ((Point2D)pos1).getY());
                for (Text txt : info.getTexts()) {
                    this.trafo.transform(txt.getLocation(), pos);
                    Font font = txt.getFont();
                    g.setFont(font.deriveFont(fontScale * font.getSize2D()));
                    g.drawString(txt.getText(), pos.x, pos.y);
                }
            }
            g.setColor(SCORE_COLOR);
            this.trafo.transform(FrameInfo.SCORE_LOCATION_GAME, pos);
            g.drawString(String.format("%7d", info.getScore()), pos.x, pos.y);
            int duration = this.getSessionTime(info);
            g.setColor(TIME_COLOR);
            g.drawString(String.format("%02d:%02d:%02d", duration / 60 / 60 % 100, duration / 60 % 60, duration % 60), size.width - 100, 20);
        }
    }

    protected int getSessionTime(FrameInfo frame) {
        if (frame.isGameRunning()) {
            if (this.startTime == -1L) {
                this.startTime = frame.getReceiveTime();
            }
            return (int)((frame.getReceiveTime() - this.startTime) / 1000L);
        }
        this.startTime = frame.getReceiveTime();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameReceived(FrameInfo frame) {
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            this.frameInfo = frame;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GameObject> pickAt(Point p, int pickRadius) {
        Point min = new Point(p.x - pickRadius, p.y + pickRadius);
        Point max = new Point(p.x + pickRadius, p.y - pickRadius);
        try {
            AffineTransform inverse = new AffineTransform(this.trafo).createInverse();
            inverse.transform(min, min);
            inverse.transform(max, max);
            Rectangle hitRect = new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
            FrameDisplay frameDisplay = this;
            synchronized (frameDisplay) {
                return this.frameInfo.getOverlappingObjects(hitRect);
            }
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    protected AffineTransform getTrafo() {
        return this.trafo;
    }

    public DrawableProvider getDrawableProvider() {
        return this.drawableProvider;
    }

    public void setDrawableProvider(DrawableProvider drawableProvider) {
        this.drawableProvider = drawableProvider;
    }
}

