/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import de.caff.asteroid.PropertyProvider;
import de.caff.asteroid.analysis.ButtonBar;
import de.caff.asteroid.analysis.EnhancedFrameDisplay;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.KeyInfoDisplay;
import de.caff.asteroid.analysis.SelectionAreaListener;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameKeyInfoDisplay
extends JPanel {
    private static final String[] COLUMNS = new String[]{"Name", "Value"};
    private static final Rectangle[] NO_BOUNDS = new Rectangle[0];
    private JTree tree;
    private JTable propertyTable;
    private Collection<SelectionAreaListener> selectionAreaListeners = new LinkedList<SelectionAreaListener>();

    public FrameKeyInfoDisplay(final TimeLine timeLine, FramePreparer velocityPreparer, DrawableProvider provider, boolean simple) {
        this.setLayout(new BorderLayout());
        EnhancedFrameDisplay frameDisplay = new EnhancedFrameDisplay(timeLine, this);
        frameDisplay.setDrawableProvider(provider);
        timeLine.addFrameListener(frameDisplay);
        if (timeLine.hasFrames()) {
            frameDisplay.frameReceived(timeLine.getCurrentInfo().getFrameInfo());
        }
        timeLine.addDumpFileChangeListener(frameDisplay);
        if (!simple) {
            this.tree = new JTree();
            this.propertyTable = new JTable();
            JScrollPane treePane = new JScrollPane(this.tree);
            JScrollPane tablePane = new JScrollPane(this.propertyTable);
            treePane.setBorder(BorderFactory.createTitledBorder("Game Objects"));
            tablePane.setBorder(BorderFactory.createTitledBorder("Properties of Selected Object"));
            timeLine.addFrameListener(new FrameListener(){

                public void frameReceived(FrameInfo frame) {
                    FrameKeyInfoDisplay.this.setTreeFrom(timeLine.getCurrentInfo());
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    Rectangle[] bounds;
                    TreePath[] paths = FrameKeyInfoDisplay.this.tree.getSelectionPaths();
                    if (paths != null) {
                        if (paths.length == 1) {
                            FrameKeyInfoDisplay.this.setTableFrom(((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject());
                        } else {
                            FrameKeyInfoDisplay.this.setTableFrom(null);
                        }
                        LinkedList<Rectangle> boundList = new LinkedList<Rectangle>();
                        for (int p = paths.length - 1; p >= 0; --p) {
                            Object obj = ((DefaultMutableTreeNode)paths[p].getLastPathComponent()).getUserObject();
                            try {
                                boundList.add(((GameObject)obj).getBounds());
                                continue;
                            }
                            catch (ClassCastException x) {
                                // empty catch block
                            }
                        }
                        bounds = boundList.toArray(new Rectangle[boundList.size()]);
                    } else {
                        FrameKeyInfoDisplay.this.setTableFrom(null);
                        bounds = NO_BOUNDS;
                    }
                    FrameKeyInfoDisplay.this.informSelectionAreaListeners(bounds);
                }
            });
            this.addSelectionAreaListener(frameDisplay);
            JSplitPane splitter = new JSplitPane(0);
            splitter.setTopComponent(new KeyInfoDisplay(timeLine));
            splitter.setBottomComponent(tablePane);
            JPanel leftPane = new JPanel(new BorderLayout());
            leftPane.add((Component)new ButtonBar(timeLine, velocityPreparer), "North");
            leftPane.add((Component)splitter, "Center");
            leftPane.add((Component)frameDisplay, "South");
            this.add((Component)treePane, "Center");
            this.add((Component)leftPane, "East");
            this.setTreeFrom(timeLine.getCurrentInfo());
            this.setMinimumSize(new Dimension(600, 300));
            this.setPreferredSize(new Dimension(800, 400));
        } else {
            this.add((Component)new ButtonBar(timeLine, velocityPreparer), "North");
            this.add((Component)frameDisplay, "Center");
        }
        frameDisplay.addMouseWheelListener(timeLine.getMouseWheelListener());
    }

    private void setTreeFrom(FrameKeyInfo info) {
        if (this.tree != null) {
            if (info != null) {
                DefaultMutableTreeNode frameNode = new DefaultMutableTreeNode(info.getFrameInfo());
                for (GameObject obj : info.getFrameInfo().getGameObjects()) {
                    frameNode.add(new DefaultMutableTreeNode(obj));
                }
                this.tree.setModel(new DefaultTreeModel(frameNode));
                this.tree.setSelectionRow(0);
            } else {
                this.tree.setModel(new DefaultTreeModel(null));
            }
        }
    }

    private void setTableFrom(Object userObj) {
        if (this.propertyTable != null) {
            Object[][] data;
            if (userObj != null && userObj instanceof PropertyProvider) {
                Collection<Property> props = ((PropertyProvider)userObj).getProperties();
                data = new Object[props.size()][2];
                int row = 0;
                for (Property p : props) {
                    data[row][0] = p.getName();
                    data[row][1] = p.getValue();
                    ++row;
                }
            } else {
                data = new Object[0][2];
            }
            this.propertyTable.setModel(new DefaultTableModel(data, COLUMNS));
        }
    }

    public void addSelectionAreaListener(SelectionAreaListener listener) {
        this.selectionAreaListeners.add(listener);
    }

    public boolean removeSelectionAreaListener(SelectionAreaListener listener) {
        return this.selectionAreaListeners.remove(listener);
    }

    protected void informSelectionAreaListeners(Rectangle[] selections) {
        for (SelectionAreaListener listener : this.selectionAreaListeners) {
            listener.selectionAreasChanged(selections);
        }
    }

    public void setSelectedUserObjects(Object[] userObjects) {
        if (this.tree != null) {
            TreePath[] selectionPaths;
            if (userObjects.length > 0) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                LinkedList<TreePath> selection = new LinkedList<TreePath>();
                FrameKeyInfoDisplay.collectSelectionPaths(root, selection, userObjects);
                selectionPaths = selection.toArray(new TreePath[selection.size()]);
            } else {
                selectionPaths = new TreePath[]{};
            }
            this.tree.setSelectionPaths(selectionPaths);
        }
    }

    private static void collectSelectionPaths(DefaultMutableTreeNode node, Collection<TreePath> selection, Object[] userObjects) {
        for (Object o : userObjects) {
            if (node.getUserObject() != o) continue;
            selection.add(new TreePath(node.getPath()));
            break;
        }
        for (int ch = 0; ch < node.getChildCount(); ++ch) {
            FrameKeyInfoDisplay.collectSelectionPaths((DefaultMutableTreeNode)node.getChildAt(ch), selection, userObjects);
        }
    }
}

