/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugLevelSwitchBoard;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.MemoryUsagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilteringDebugMessageWindow
extends JFrame
implements CookedMessageDebugListener {
    private static final String[] TYPE_NAMES = new String[]{Character.toString('T'), Character.toString('S'), Character.toString('W'), Character.toString('E'), Character.toString('F'), Character.toString('L'), Character.toString('A')};
    private JTextArea _msgArea;
    private int _endPos;
    private Collection _msgList = new LinkedList();
    private long _filterMask = 127L;
    private PositionTree _positionTree;
    private JLabel _statusLine;
    private int _nrDisplayed;
    private int[] _nrMessages = new int[7];
    private boolean _appendWindow = true;
    private StringBuffer _refilterBuffer = new StringBuffer();

    public FilteringDebugMessageWindow() {
        super("Debug Messages");
        this.setDefaultCloseOperation(0);
        Border border = BorderFactory.createLoweredBevelBorder();
        this._msgArea = new JTextArea(25, 100);
        this._msgArea.setFont(new Font("Monospaced", 0, 12));
        this._msgArea.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane();
        this.getContentPane().add(jSplitPane);
        jSplitPane.setLeftComponent(new JScrollPane(this._msgArea));
        this._statusLine = new JLabel();
        this.getContentPane().add("South", this._statusLine);
        this._statusLine.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(300, 400));
        jPanel.add(jTabbedPane);
        jSplitPane.setRightComponent(jPanel);
        JPanel jPanel2 = new DebugLevelSwitchBoard();
        jPanel2.setBorder(border);
        jTabbedPane.addTab("Global Settings", null, jPanel2, "Allows to change global debug settings");
        jPanel2 = new MemoryUsagePanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jTabbedPane.addTab("Memory", null, jPanel2, "Memory Usage and Garbage Collection");
        jPanel2 = new MessageTypeFilterBoard();
        jPanel2.setBorder(border);
        jTabbedPane.addTab("Filter by Type", null, jPanel2, "Filtering of received and future messages by message type");
        this._positionTree = new PositionTree();
        jPanel2 = this._positionTree;
        jPanel2.setBorder(border);
        jTabbedPane.addTab("Filter by Position", null, jPanel2, "Filtering of received and future messages by file position");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add("South", jPanel3);
        JButton jButton = new JButton("Print System Properties");
        jPanel3.add("North", jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilteringDebugMessageWindow.this.printProperties();
            }
        });
        jButton.setToolTipText("Print the system properties in the text window");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0));
        jPanel3.add("South", jPanel4);
        jButton = new JButton("Clear");
        jPanel4.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilteringDebugMessageWindow.this.clear();
            }
        });
        jButton.setToolTipText("Clears the text window and the message storage");
        jButton = new JButton("Save...");
        jPanel4.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilteringDebugMessageWindow.this.save();
            }
        });
        jButton.setToolTipText("Allows to save the content of the text window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.removeCookedMessageDebugListener(FilteringDebugMessageWindow.this);
                FilteringDebugMessageWindow.this.dispose();
            }
        });
        Debug.addCookedMessageDebugListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void receiveCookedMessage(int n, String string, String string2) {
        Message message = this.addToMessageList(n, string, string2);
        this.possiblyDisplayMessage(message);
        this.updateStatus();
    }

    private Message addToMessageList(int n, String string, String string2) {
        int n2 = n;
        this._nrMessages[n2] = this._nrMessages[n2] + 1;
        Message message = new Message(n, string, string2);
        this._msgList.add(message);
        Object object = this._positionTree.appendPosition(string2);
        message.setNode(object);
        return message;
    }

    private void possiblyDisplayMessage(final Message message) {
        if (message.isTypeConform(this._filterMask) && this._positionTree.allows(message)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showMessage(message);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FilteringDebugMessageWindow.this.showMessage(message);
                    }
                });
            }
        }
    }

    private void showMessage(Message message) {
        String string = message.toString();
        this.append(string);
    }

    private void append(String string) {
        ++this._nrDisplayed;
        if (this._appendWindow) {
            this._msgArea.append(string);
            this._endPos += string.length();
            this._msgArea.setCaretPosition(this._endPos);
        } else {
            this._refilterBuffer.append(string);
        }
    }

    private void clear() {
        this._msgList.clear();
        Arrays.fill(this._nrMessages, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilteringDebugMessageWindow.this.clearTextWindow();
            }
        });
    }

    private void clearTextWindow() {
        this._msgArea.setText("");
        this._nrDisplayed = 0;
        this._endPos = 0;
        this.updateStatus();
    }

    private void updateStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Shown messages: ").append(this._nrDisplayed).append('/').append(this._msgList.size()).append(" (");
        for (int i = 0; i < TYPE_NAMES.length; ++i) {
            if (i != 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(this._nrMessages[i]).append(TYPE_NAMES[i]);
        }
        stringBuffer.append(')');
        this._statusLine.setText(stringBuffer.toString());
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showDialog(this, "Sichern") == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this._msgArea.getText());
                fileWriter.write("\n=== Memory Usage Information ===\n");
                System.gc();
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.freeMemory();
                long l2 = runtime.totalMemory();
                long l3 = l2 - l;
                fileWriter.write("\t used JVM memory: " + l3 + " Bytes\n");
                fileWriter.write("\t free JVM memory: " + l + " Bytes\n");
                fileWriter.write("\ttotal JVM memory: " + l2 + " Bytes\n");
                fileWriter.write("\n=== System Information ===\n");
                Iterator iterator = FilteringDebugMessageWindow.getSystemPropertyList().iterator();
                while (iterator.hasNext()) {
                    fileWriter.write("\t" + iterator.next().toString() + "\n");
                }
                fileWriter.write("=== EOF ===\n");
                fileWriter.close();
                Debug.message("Debugmeldungen gesichert in \"%1\"", file);
            }
            catch (Exception exception) {
                Debug.error("Sichern von \"%1\" gescheitert.\nGrund:\n%2", file, exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refilterDisplay() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.clearTextWindow();
            this._refilterBuffer.setLength(0);
            this._appendWindow = false;
            Iterator iterator = this._msgList.iterator();
            while (iterator.hasNext()) {
                this.possiblyDisplayMessage((Message)iterator.next());
            }
            this._appendWindow = true;
            this.append(this._refilterBuffer.toString());
            --this._nrDisplayed;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.updateStatus();
        }
    }

    private void printProperties() {
        this.append("SYSTEM PROPERTIES:\n");
        Iterator iterator = FilteringDebugMessageWindow.getSystemPropertyList().iterator();
        while (iterator.hasNext()) {
            this.append("\t" + iterator.next().toString() + "\n");
        }
    }

    public static Collection getSystemPropertyList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                arrayList.add(string + " = \"" + System.getProperty(string) + "\"");
            }
            catch (SecurityException securityException) {
                arrayList.add(string + " not available due to security restrictions");
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private class PositionTree
    extends JPanel {
        private JTree _tree;
        private HashMap _positions = new HashMap(89);

        public PositionTree() {
            super(new BorderLayout());
            this._tree = new JTree(new DefaultTreeModel(new PositionNode(""), true));
            this._tree.putClientProperty("JTree.lineStyle", "Angled");
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new DefaultTreeCellRenderer(this){
                private Font _excludedFont;
                private Font _includedFont;
                private final /* synthetic */ PositionTree this$1;
                {
                    this.this$1 = positionTree;
                }

                private void initFonts(JTree jTree) {
                    Font font = jTree.getFont();
                    this._includedFont = font.deriveFont(1);
                    this._excludedFont = font.deriveFont(0);
                }

                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    PositionNode positionNode = (PositionNode)object;
                    JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    jLabel.setFont(jTree.getFont().deriveFont(positionNode.isIncluded() ? 1 : 0));
                    return jLabel;
                }
            });
            this.add((Component)new JScrollPane(this._tree), "Center");
            JPanel jPanel = new JPanel(new GridLayout(0, 2));
            JButton jButton = new JButton("Include");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PositionTree this$1;
                {
                    this.this$1 = positionTree;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PositionTree.access$300(this.this$1);
                }
            });
            jButton.setToolTipText("Includes the currently selected nodes and branches into the displayed messages");
            jPanel.add(jButton);
            jButton = new JButton("Exclude");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PositionTree this$1;
                {
                    this.this$1 = positionTree;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PositionTree.access$400(this.this$1);
                }
            });
            jButton.setToolTipText("Excludes the currently selected nodes and branches from the displayed messages");
            jPanel.add(jButton);
            this.add((Component)jPanel, "South");
        }

        public void clear() {
            this._tree.setModel(new DefaultTreeModel(new PositionNode(""), true));
            this._positions.clear();
        }

        public Object appendPosition(String string) {
            Object object = this._positions.get(string);
            if (object == null) {
                Object[] objectArray;
                if ("???".equals(string)) {
                    objectArray = new Object[]{string};
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
                    ArrayList<Object> arrayList = new ArrayList<Object>(32);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string4 = stringTokenizer2.nextToken();
                        int n = string4.indexOf(36);
                        if (n > 0) {
                            arrayList.add(string4.substring(0, n));
                            arrayList.add(string4.substring(n));
                            continue;
                        }
                        arrayList.add(string4);
                    }
                    int n = string3.indexOf(58) + 1;
                    if (n <= 0) {
                        n = string3.indexOf(44) + 1;
                        if (n <= 0) {
                            arrayList.add(string3);
                        } else {
                            arrayList.add(string3.substring(n).trim());
                        }
                    } else {
                        string3 = string3.substring(n);
                        try {
                            arrayList.add(Integer.decode(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            arrayList.add(string3);
                        }
                    }
                    objectArray = arrayList.toArray();
                }
                object = this.appendPath(objectArray);
                this._positions.put(string, object);
            }
            return object;
        }

        private Object appendPath(Object[] objectArray) {
            TreeModel treeModel = this._tree.getModel();
            PositionNode positionNode = (PositionNode)treeModel.getRoot();
            return this.append(positionNode, objectArray, 0);
        }

        private Object append(PositionNode object, Object[] objectArray, int n) {
            Object object2;
            Serializable serializable;
            int n2;
            for (n2 = 0; n2 < ((DefaultMutableTreeNode)object).getChildCount(); ++n2) {
                serializable = (PositionNode)((DefaultMutableTreeNode)object).getChildAt(n2);
                object2 = ((DefaultMutableTreeNode)serializable).getUserObject();
                int n3 = object2.getClass() == objectArray[n].getClass() ? ((Comparable)object2).compareTo(objectArray[n]) : object2.toString().compareTo(objectArray[n].toString());
                if (n3 == 0) {
                    if (++n == objectArray.length) {
                        return serializable;
                    }
                    return this.append((PositionNode)serializable, objectArray, n);
                }
                if (n3 > 0) break;
            }
            serializable = (DefaultTreeModel)this._tree.getModel();
            object2 = null;
            while (n < objectArray.length) {
                object2 = new PositionNode(objectArray[n], n < objectArray.length - 1);
                ((PositionNode)object2).setIncluded(((PositionNode)object).isIncluded());
                ((DefaultTreeModel)serializable).insertNodeInto((MutableTreeNode)object2, (MutableTreeNode)object, n2);
                object = object2;
                n2 = 0;
                ++n;
            }
            return object2;
        }

        private PositionNode nodeForPath(TreePath treePath) {
            return (PositionNode)treePath.getLastPathComponent();
        }

        private void includeSelection() {
            TreePath[] treePathArray = this._tree.getSelectionPaths();
            for (int i = 0; i < treePathArray.length; ++i) {
                PositionNode positionNode = this.nodeForPath(treePathArray[i]);
                positionNode.setIncluded(true);
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }

        private void excludeSelection() {
            TreePath[] treePathArray = this._tree.getSelectionPaths();
            for (int i = 0; i < treePathArray.length; ++i) {
                PositionNode positionNode = this.nodeForPath(treePathArray[i]);
                positionNode.setIncluded(false);
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }

        public boolean allows(Message message) {
            return ((PositionNode)message.getNode()).isIncluded();
        }

        static /* synthetic */ void access$300(PositionTree positionTree) {
            positionTree.includeSelection();
        }

        static /* synthetic */ void access$400(PositionTree positionTree) {
            positionTree.excludeSelection();
        }

        private class PositionNode
        extends DefaultMutableTreeNode {
            private boolean _included = true;

            public PositionNode(Object object) {
                super(object);
            }

            public PositionNode(Object object, boolean bl) {
                super(object, bl);
            }

            private void setIncludedDirect(boolean bl) {
                if (bl != this._included) {
                    this._included = bl;
                    ((DefaultTreeModel)PositionTree.this._tree.getModel()).nodeChanged(this);
                }
            }

            public void setIncluded(boolean bl) {
                this.setIncludedDirect(bl);
                if (!this.isLeaf()) {
                    Enumeration<TreeNode> enumeration = this.children();
                    while (enumeration.hasMoreElements()) {
                        ((PositionNode)enumeration.nextElement()).setIncluded(bl);
                    }
                }
            }

            public boolean isIncluded() {
                return this._included;
            }

            private void checkChildrenInclude() {
                if (!this._included) {
                    Object object = this.children();
                    while (object.hasMoreElements()) {
                        if (((PositionNode)object.nextElement()).isIncluded()) continue;
                        return;
                    }
                    this.setIncludedDirect(true);
                    object = (PositionNode)this.getParent();
                    if (object != null) {
                        super.checkChildrenInclude();
                    }
                }
            }

            public Object clone() {
                return new PositionNode(this.getUserObject(), this.allowsChildren);
            }
        }
    }

    private class MessageTypeFilterBoard
    extends JPanel {
        public MessageTypeFilterBoard() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new FilterCheckBox("Display trace messages", 1L, "Toggles the display of trace debug messages."));
            this.add(new FilterCheckBox("Display standard messages", 2L, "Toggles the display of standard debug messages."));
            this.add(new FilterCheckBox("Display warning messages", 4L, "Toggles the display of warning debug messages."));
            this.add(new FilterCheckBox("Display error messages", 8L, "Toggles the display of error debug messages."));
            this.add(new FilterCheckBox("Display fatal error messages", 16L, "Toggles the display of fatal error debug messages."));
            this.add(new FilterCheckBox("Display logging messages", 32L, "Toggles the display of logging messages."));
            this.add(new FilterCheckBox("Display failed assertion messages", 64L, "Toggles the display of failed assertion messages."));
        }
    }

    private class FilterCheckBox
    extends JCheckBox
    implements ItemListener {
        private long _mask;

        public FilterCheckBox(String string, long l, String string2) {
            super(string, true);
            this.setSelected((FilteringDebugMessageWindow.this._filterMask & l) != 0L);
            this._mask = l;
            this.addItemListener(this);
            if (string2 != null) {
                this.setToolTipText(string2);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                FilteringDebugMessageWindow.this._filterMask |= this._mask;
            } else {
                FilteringDebugMessageWindow.this._filterMask &= this._mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }
    }

    private static class Message {
        private long _mask;
        private String _message;
        private String _pos;
        private Object _node;

        public Message(int n, String string, String string2) {
            this._mask = 1L << n;
            this._message = string;
            this._pos = string2;
        }

        public void setNode(Object object) {
            this._node = object;
        }

        public Object getNode() {
            return this._node;
        }

        public String toString() {
            return this._message + DebugMessageCook.cookedPosition(this._pos);
        }

        public boolean isTypeConform(long l) {
            return (l & this._mask) != 0L;
        }
    }
}

