/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.i18n.I18n;
import de.caff.util.settings.EnumValue;
import java.util.Locale;
import java.util.prefs.Preferences;

public class LocaleEnumValue
implements EnumValue {
    private final Locale locale;

    public LocaleEnumValue(Locale locale) {
        this.locale = locale;
    }

    public String getShortName(Locale locale) {
        return this.locale == null ? I18n.getString("localeDefault", locale) : this.locale.getDisplayName(locale);
    }

    public String getLongName(Locale locale) {
        return null;
    }

    public void storeTo(Preferences preferences, String string) {
        if (this.locale == null) {
            preferences.remove(string);
        } else {
            preferences.put(string, this.locale.toString());
        }
    }

    public boolean isEqualTo(Preferences preferences, String string) {
        String string2 = preferences.get(string, null);
        return this.locale == null && string2 == null || this.locale != null && this.locale.toString().equals(string2);
    }

    public Object getRealValue() {
        return this.locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

