// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import de.caff.util.Worker;
import de.caff.util.KnockOffListener;

import java.io.InputStream;

/**
 *  Worker for loading of dump files in background.
 */
public class DumpLoader
        extends Worker
{
  private String filename;
  private InputStream inputStream;
  private DumpLoadingListener dumpLoadingListener;
  /** Dump file loaded if successful. */
  private DumpFile dumpFile;

  /**
   * Constructor taking an intial knock off listener.
   *
   * @param filename filename to read from
   * @param listener knock off listener
   */
  public DumpLoader(String filename, KnockOffListener listener)
  {
    this(null, filename, listener, null);
  }

  /**
   * Constructor taking an intial knock off listener.
   *
   * @param is       input stream to read from
   * @param filename filename associated with input stream
   * @param listener knock off listener
   */
  public DumpLoader(InputStream is, String filename, KnockOffListener listener)
  {
    this(is, filename, listener, null);
  }

  /**
   * Constructor taking an intial knock off listener.
   *
   * @param filename filename associated with input stream
   * @param listener knock off listener
   * @param dumpLoadingListener listener for mark changes (used for progress)
   */
  public DumpLoader(String filename, KnockOffListener listener, DumpLoadingListener dumpLoadingListener)
  {
    this(null, filename, listener, dumpLoadingListener);
  }

  /**
   * Constructor taking an intial knock off listener.
   *
   * @param is       input stream to read from
   * @param filename filename associated with input stream
   * @param listener knock off listener
   * @param dumpLoadingListener listener for mark changes (used for progress)
   */
  public DumpLoader(InputStream is, String filename, KnockOffListener listener, DumpLoadingListener dumpLoadingListener)
  {
    super(listener);
    this.dumpLoadingListener = dumpLoadingListener;
    this.inputStream = is;
    this.filename = filename;
  }

  /**
   * Implement this in extending classes to do the work.
   *
   * @throws Throwable any exception thrown during work
   */
  protected void execute() throws Throwable
  {
    dumpFile = inputStream != null ?
            new DumpFile(inputStream, filename, dumpLoadingListener)  :
            new DumpFile(filename, dumpLoadingListener);
  }

  /**
   *  Get the dumpfile.
   *  @return dumpfile if loading succeded
   */
  public DumpFile getDumpFile()
  {
    return dumpFile;
  }
}
