// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

/**
 *  Time line used for progress display.
 */
public class ProgressTimeLine
        extends AbstractBasicTimeLine
        implements DumpLoadingListener
  
{
  /** The number of expected frames. */
  private int nrFrames;
  /** The currently read frame. */
  private int currentFrame;
  /** The marks. */
  private List<DumpFile.Mark> marks = new ArrayList<DumpFile.Mark>();

  /**
   * Constructor.
   */
  public ProgressTimeLine()
  {
  }

  /**
   * Get the marks to display.
   *
   * @return marks
   */
  protected Collection<DumpFile.Mark> getMarks()
  {
    Collection<DumpFile.Mark> result;
    synchronized (marks) {
      result = new ArrayList<DumpFile.Mark>(marks.size() + 1);
      result.addAll(marks);
    }
    result.add(new DumpFile.Mark(currentFrame, DumpFile.MarkType.DUMP_END));
    return result;
  }

  /**
   * Get the number of frames to display.
   *
   * @return frame count
   */
  public int getFrameCount()
  {
    return nrFrames == 0 ? currentFrame + 1 : nrFrames;
  }

  /**
   * Set the numbers of frames to expect.
   *
   * @param frameCount the expected frame count
   */
  public void setExpectedFrames(int frameCount)
  {
    nrFrames = frameCount;
    synchronized (marks) {
      marks.clear();
    }
    repaint();
  }

  /**
   * Called if the marks change.
   *
   * @param marks new list of marks
   */
  public void marksChanged(Collection<DumpFile.Mark> marks)
  {
    synchronized (this.marks) {
      this.marks.clear();
      this.marks.addAll(marks);
    }
    repaint();
  }

  /**
   * Called if the number of frames changes.
   *
   * @param frameCount new frame count
   */
  public void frameCountChanged(int frameCount)
  {
    currentFrame = frameCount;
    repaint();
  }
}
