/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceShip
extends MovingGameObject {
    private static final Color COLOR = new Color(192, 192, 192);
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    private final int dx;
    private final int dy;

    public SpaceShip(int x, int y, int dx, int dy) {
        super(x, y);
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public int getSize() {
        return 13;
    }

    public int getDirX() {
        return this.dx;
    }

    public int getDirY() {
        return this.dy;
    }

    public double getDirectionAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    public Point getDirection() {
        return new Point(this.dx, this.dy);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        g.fill(SpaceShip.getShipShape(this.x, this.y, this.getDirectionAngle()));
        this.drawVelocityVector(g, Color.green);
    }

    public static Shape getShipShape(int px, int py, double angle) {
        AffineTransform at = AffineTransform.getTranslateInstance(px, py);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        return at.createTransformedShape(SHIP_SHAPE);
    }

    public String toString() {
        return String.format("SpaceShip@(%d,%d)>(%-3.1f\u00b0)", this.x, this.y, 180.0 * this.getDirectionAngle() / Math.PI);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Point>("Direction", this.getDirection()));
        props.add(new Property<Double>("Direction Angle (\u00b0)", 180.0 * this.getDirectionAngle() / Math.PI));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Space Ship";
    }

    static {
        SHIP_SHAPE.moveTo(13.0f, 0.0f);
        SHIP_SHAPE.lineTo(-13.0f, 10.0f);
        SHIP_SHAPE.lineTo(-8.0f, 0.0f);
        SHIP_SHAPE.lineTo(-13.0f, -10.0f);
        SHIP_SHAPE.closePath();
    }
}

