/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.i18n.I18n4Java1;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class I18n {
    static boolean DEBUG;
    private static final I18n i18n;
    public static final String SUFFIX_TEXT = "-NAME";
    public static final String SUFFIX_TOOLTIP = "-TTT";
    public static final String SUFFIX_DESCRIPTION = "-DESCR";
    public static final String SUFFIX_ACCELERATOR = "-ACCEL";
    public static final String SUFFIX_MNEMONIC = "-MNEMO";
    public static final String SUFFIX_ICON = "-ICON";
    public static final String SUFFIX_DISABLED_ICON = "-ICON-DIS";
    public static final String SUFFIX_INACTIVE_ICON = "-ICON-INACT";

    public static void addAppResourceBase(String string) {
        if (i18n != null) {
            i18n._addAppResourceBase(string);
        }
    }

    protected abstract void _addAppResourceBase(String var1);

    public static void setDefaultLocale(Locale locale) {
        i18n._setDefaultLocale(locale);
    }

    protected abstract void _setDefaultLocale(Locale var1);

    public static Locale getDefaultLocale() {
        return i18n._getDefaultLocale();
    }

    protected abstract Locale _getDefaultLocale();

    private static final ResourceBundle getBundle(Locale locale) throws MissingResourceException {
        return i18n._getBundle(locale);
    }

    protected abstract ResourceBundle _getBundle(Locale var1) throws MissingResourceException;

    public static String getString(String string) throws MissingResourceException {
        return I18n.getString(string, null);
    }

    public static String getString(String string, Locale locale) throws MissingResourceException {
        return I18n.getBundle(locale).getString(string);
    }

    public static String format(String string, Object[] objectArray) throws MissingResourceException {
        return I18n.format(string, objectArray, null);
    }

    public static String format(String string, Object object) throws MissingResourceException {
        return I18n.format(string, new Object[]{object});
    }

    public static String format(String string, Object object, Object object2) throws MissingResourceException {
        return I18n.format(string, new Object[]{object, object2});
    }

    public static String format(String string, Object object, Object object2, Object object3) throws MissingResourceException {
        return I18n.format(string, new Object[]{object, object2, object3});
    }

    public static String format(String string, Object[] objectArray, Locale locale) throws MissingResourceException {
        return Utility.compileString(string, objectArray, I18n.getBundle(locale));
    }

    public static String format(String string, Object object, Locale locale) throws MissingResourceException {
        return I18n.format(string, new Object[]{object}, locale);
    }

    public static String format(String string, Object object, Object object2, Locale locale) throws MissingResourceException {
        return I18n.format(string, new Object[]{object, object2}, locale);
    }

    public static String format(String string, Object object, Object object2, Object object3, Locale locale) throws MissingResourceException {
        return I18n.format(string, new Object[]{object, object2, object3}, locale);
    }

    public static void addLocalizationChangeListener(Localizable localizable) {
        i18n._addLocalizationChangeListener(localizable);
    }

    protected abstract void _addLocalizationChangeListener(Localizable var1);

    public static void removeLocalizationChangeListener(Localizable localizable) {
        i18n._removeLocalizationChangeListener(localizable);
    }

    protected abstract void _removeLocalizationChangeListener(Localizable var1);

    protected abstract void _fireLocaleChanged(Locale var1);

    static {
        String string;
        DEBUG = false;
        try {
            string = System.getProperty("java.vm.version");
        }
        catch (Throwable throwable) {
            string = null;
        }
        I18n i18n = new I18n4Java1();
        if (string != null && !string.startsWith("1.1")) {
            try {
                i18n = (I18n)Class.forName("de.caff.i18n.java2.I18n4Java2").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        I18n.i18n = i18n;
    }
}

