/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.java2;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.ResourceBundleCollection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class I18n4Java2
extends I18n {
    protected Map resourceBundles = new HashMap();
    protected Set appResourceBases = new HashSet();
    protected Locale defaultLocale = Locale.getDefault();
    protected List localizables = new ArrayList();

    protected void _addAppResourceBase(String string) {
        if (!this.appResourceBases.contains(string)) {
            this.appResourceBases.add(string);
            this.resourceBundles.clear();
        }
    }

    private static ResourceBundle getFallbackResourceBundle(String string) {
        ResourceBundle resourceBundle;
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingResourceException("Can't load fallback resources " + string, string, "");
        }
        try {
            resourceBundle = (ResourceBundle)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create ResourceBundle " + string);
        }
        return resourceBundle;
    }

    protected void _setDefaultLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.defaultLocale = locale;
        this._fireLocaleChanged(locale);
    }

    protected Locale _getDefaultLocale() {
        return this.defaultLocale;
    }

    protected ResourceBundle _getBundle(Locale locale) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = this.defaultLocale;
        }
        if ((resourceBundle = (ResourceBundle)this.resourceBundles.get(locale)) == null) {
            if (this.appResourceBases.size() == 0) {
                throw new MissingResourceException("No application specific resource base defined", "<unknown>", "");
            }
            ResourceBundleCollection resourceBundleCollection = new ResourceBundleCollection();
            Iterator iterator = this.appResourceBases.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    resourceBundleCollection.addResourceBundle(ResourceBundle.getBundle(string, locale));
                }
                catch (MissingResourceException missingResourceException) {
                    resourceBundleCollection.addResourceBundle(I18n4Java2.getFallbackResourceBundle(string));
                }
            }
            this.resourceBundles.put(locale, resourceBundleCollection);
            return resourceBundleCollection;
        }
        return resourceBundle;
    }

    protected void _addLocalizationChangeListener(Localizable localizable) {
        this.localizables.add(new WeakReference<Localizable>(localizable));
        localizable.setLocale(this._getDefaultLocale());
    }

    protected void _removeLocalizationChangeListener(Localizable localizable) {
        this.localizables.remove(localizable);
    }

    protected void _fireLocaleChanged(Locale locale) {
        ListIterator listIterator = this.localizables.listIterator();
        while (listIterator.hasNext()) {
            WeakReference weakReference = (WeakReference)listIterator.next();
            Localizable localizable = (Localizable)weakReference.get();
            if (localizable != null) {
                localizable.setLocale(locale);
                continue;
            }
            listIterator.remove();
        }
    }
}

