/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.EventQueueExceptionListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

class EventQueueExceptionWrapper
extends EventQueue {
    private Collection listeners = new LinkedList();

    public EventQueueExceptionWrapper() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            super.dispatchEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                EventQueueExceptionListener eventQueueExceptionListener = (EventQueueExceptionListener)iterator.next();
                eventQueueExceptionListener.exceptionOccured(aWTEvent, throwable);
            }
        }
    }

    public void addEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        this.listeners.add(eventQueueExceptionListener);
    }

    public void removeEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        this.listeners.remove(eventQueueExceptionListener);
    }
}

