/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

class DebugMessageCook
implements AnyMessageDebugListener,
DebugConstants {
    private static final boolean THROW_ASSERTION_EXCEPTION = true;
    private static final boolean STOP_ON_FATAL_ERRORS = true;
    private static final boolean EMPTY_THROW_ASSERTION = false;
    private static final int EMPTY_FATAL_RETURN = 0;
    private static final String HEAD_TRACE = "TRACE";
    private static final String HEAD_MESSAGE = "MESSAGE";
    private static final String HEAD_WARNING = "WARNING";
    private static final String HEAD_ERROR = "ERROR";
    private static final String HEAD_FATAL = "FATAL ERROR";
    private static final String HEAD_LOG = "LOGGING";
    private static final String HEAD_ASSERTION = "ASSERTION FAILED";
    private LinkedList _list = new LinkedList();

    DebugMessageCook() {
    }

    public void addListener(CookedMessageDebugListener cookedMessageDebugListener) {
        this._list.add(new ListenerData(cookedMessageDebugListener, true, true));
    }

    public void addListener(CookedMessageDebugListener cookedMessageDebugListener, boolean bl, boolean bl2) {
        this._list.add(new ListenerData(cookedMessageDebugListener, bl, bl2));
    }

    public void removeListener(CookedMessageDebugListener cookedMessageDebugListener) {
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            if (listenerData.listener != cookedMessageDebugListener) continue;
            iterator.remove();
            break;
        }
    }

    private static String getFormatted(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DateFormat.getDateTimeInstance().format(new Date())).append('\t').append(string).append(":\n");
        int n = 0;
        int n2 = string2.indexOf(10);
        while (n2 != -1) {
            stringBuffer.append('\t').append(string2.substring(n, n2 + 1));
            n = n2 + 1;
            n2 = string2.indexOf(10, n);
        }
        stringBuffer.append('\t').append(string2.substring(n)).append('\n');
        return stringBuffer.toString();
    }

    private void distribute(int n, String string, String string2) {
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            ((ListenerData)iterator.next()).listener.receiveCookedMessage(n, string, string2);
        }
    }

    private int distributeFatal(String string, String string2) {
        boolean bl = false;
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            listenerData.listener.receiveCookedMessage(4, string, string2);
            if (bl || !listenerData.stopOnFatalErrors) continue;
            bl = true;
        }
        return bl ? 1 : 0;
    }

    private boolean distributeFailedAssertion(String string, String string2) {
        boolean bl = false;
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            listenerData.listener.receiveCookedMessage(6, string, string2);
            if (bl || !listenerData.stopOnFatalErrors) continue;
            bl = true;
        }
        return bl;
    }

    public void receiveTraceMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            this.distribute(0, DebugMessageCook.getFormatted(HEAD_TRACE, string), string2);
        }
    }

    public void receiveStandardMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            this.distribute(1, DebugMessageCook.getFormatted(HEAD_MESSAGE, string), string2);
        }
    }

    public void receiveWarningMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            this.distribute(2, DebugMessageCook.getFormatted(HEAD_WARNING, string), string2);
        }
    }

    public void receiveErrorMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            this.distribute(3, DebugMessageCook.getFormatted(HEAD_ERROR, string), string2);
        }
    }

    public void receiveLogMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            this.distribute(5, DebugMessageCook.getFormatted(HEAD_LOG, string), string2);
        }
    }

    public int receiveFatalMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            return this.distributeFatal(DebugMessageCook.getFormatted(HEAD_FATAL, string), string2);
        }
        return 0;
    }

    public boolean receiveFailedAssertionMessage(String string, String string2) {
        if (!this._list.isEmpty()) {
            return this.distributeFailedAssertion(DebugMessageCook.getFormatted(HEAD_ASSERTION, string), string2);
        }
        return false;
    }

    public static String cookedPosition(String string) {
        return "\t[at " + string + "]\n";
    }

    static class ListenerData {
        CookedMessageDebugListener listener;
        boolean stopOnFatalErrors;
        boolean throwAssertionException;

        ListenerData(CookedMessageDebugListener cookedMessageDebugListener, boolean bl, boolean bl2) throws NullPointerException {
            if (cookedMessageDebugListener == null) {
                throw new NullPointerException();
            }
            this.listener = cookedMessageDebugListener;
            this.stopOnFatalErrors = bl;
            this.throwAssertionException = bl2;
        }
    }
}

