/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text
extends GameObject {
    private static FontRenderContext fontRenderContext = null;
    public static final Font FONT = new Font("Monospaced", 0, 14);
    private final String text;
    private final int scale;

    public Text(String text, int x, int y, int scale) {
        super(x, y);
        this.text = text;
        this.scale = (int)Math.pow(2.0, scale);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.format("Text(%s)@(%d,%d)", this.text, this.x, this.y);
    }

    public boolean hasLocation(int px, int py) {
        return px == this.x && py == this.y;
    }

    public boolean hasLocation(Point p) {
        return this.hasLocation(p.x, p.y);
    }

    @Override
    public Rectangle getBounds() {
        if (fontRenderContext != null) {
            Rectangle bounds = this.getFont().getStringBounds(this.getText(), fontRenderContext).getBounds();
            bounds.y = -bounds.height - bounds.y;
            bounds.translate(this.getX(), this.getY());
            return bounds;
        }
        return new Rectangle(this.getLocation(), new Dimension(100, 20));
    }

    public int getScale() {
        return this.scale;
    }

    public Font getFont() {
        return FONT.deriveFont((float)(FONT.getSize() * this.scale));
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<String>("Text", this.getText()));
        props.add(new Property<Integer>("Scale", this.getScale()));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Text";
    }

    public static void setFontRenderContext(FontRenderContext ctx) {
        fontRenderContext = ctx;
    }
}

