/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameDisplay;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.analysis.DumpFileChangeListener;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.SelectionAreaListener;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public class EnhancedFrameDisplay
extends FrameDisplay
implements SelectionAreaListener,
DumpFileChangeListener {
    private static final Color SELECTION_COLOR = Color.magenta;
    private Rectangle[] selections = new Rectangle[0];
    private TimeLine timeLine;

    public EnhancedFrameDisplay(TimeLine timeLine) {
        this(0, timeLine, null);
    }

    public EnhancedFrameDisplay(TimeLine timeLine, FrameKeyInfoDisplay fid) {
        this(0, timeLine, fid);
    }

    public EnhancedFrameDisplay(int width, TimeLine timeLine, final FrameKeyInfoDisplay fid) {
        super(width);
        this.timeLine = timeLine;
        if (fid != null) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        Collection<GameObject> gameObjects = EnhancedFrameDisplay.this.pickAt(e.getPoint(), 2);
                        fid.setSelectedUserObjects(gameObjects.toArray(new GameObject[gameObjects.size()]));
                    }
                }
            });
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(SELECTION_COLOR);
        AffineTransform trafo = this.getTrafo();
        for (Rectangle rect : this.selections) {
            GeneralPath p = new GeneralPath();
            p.moveTo((float)rect.getMinX(), (float)rect.getMinY());
            p.lineTo((float)rect.getMaxX(), (float)rect.getMinY());
            p.lineTo((float)rect.getMaxX(), (float)rect.getMaxY());
            p.lineTo((float)rect.getMinX(), (float)rect.getMaxY());
            p.closePath();
            p.transform(trafo);
            g2.draw(p);
        }
    }

    public void selectionAreasChanged(Rectangle[] areas) {
        this.selections = areas;
        this.repaint();
    }

    public void dumpFileChange() {
        this.repaint();
    }

    protected int getSessionTime(FrameInfo frame) {
        return this.timeLine.getSessionTime(frame.getIndex()) / 1000;
    }
}

