// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.util.Collection;

/**
 * Bullet object in automated player of Asteroids game.
 *
 * Bullets are either shot by the player's ship or by an ufo.
 *
 * This class is part of a solution for a
 * <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class Bullet
        extends MovingGameObject
{
  /** Index of the asteroid in datagram. */
  private final int index;

  /**
   *  Constructor.
   *  @param index index of bullet in datagram
   *  @param x  x coordinate
   *  @param y  y coordinate
   */
  public Bullet(int index, int x, int y)
  {
    super(x, y);
    this.index = index;
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return 0;
  }

  /**
   *  Get the index of this bullet in the datagram.
   *  @return index in datagram
   */
  public int getIndex()
  {
    return index;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  public void draw(Graphics2D g)
  {
    drawVelocityVector(g, Color.blue);

    g.setColor(Color.white);
    g.fillOval(x-1, y-1, 3, 3);
  }

  /**
   * Get the properties of this object.
   *
   * @return collection of properties
   */
  @Override
  public Collection<Property> getProperties()
  {
    Collection<Property> props = super.getProperties();
    props.add(new Property<Integer>("Lifetime", getLifetime()));
    return props;
  }

  /**
   * Get the type of game object.
   *
   * @return game object type
   */
  public String getObjectType()
  {
    return "Bullet";
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Bullet@(%d,%d)", getX(), getY());
  }

  /**
   * Get the bounding box of this rectangle.
   *
   * @return the bounding box
   */
  @Override
  public Rectangle getBounds()
  {
    return new Rectangle(getX()-1, getY()-1, 2, 2);
  }
}
