/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.EventQueueExceptionListener;
import de.caff.util.EventQueueExceptionWrapper;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class Utility {
    public static final float PHYS_RED_SCALE = 0.3f;
    public static final float PHYS_GREEN_SCALE = 0.53f;
    public static final float PHYS_BLUE_SCALE = 0.17000002f;
    private static Component preparer = new Canvas();
    private static boolean weAreOnDOS = File.separatorChar == '\\';
    private static String resourceDir = "resources/";
    private static Applet applet = null;
    private static EventQueueExceptionWrapper exceptionWrapper = null;
    private static boolean debugging = false;

    public static void setDebug(boolean bl) {
        debugging = bl;
    }

    public static boolean isDebug() {
        return debugging;
    }

    public static Image loadImage(String string) {
        return Utility.loadImage(string, preparer);
    }

    public static Image loadImage(String string, Component component) {
        if (resourceDir != null && !string.startsWith("/")) {
            string = resourceDir + string;
        }
        return new Utility().loadAnImage(string, component);
    }

    private Image loadAnImage(String string, Component component) {
        Image image = null;
        try {
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                if (applet != null) {
                    uRL = new URL(applet.getDocumentBase(), "de/caff/gimmicks/" + string);
                } else {
                    return null;
                }
            }
            image = applet != null ? applet.getImage(uRL) : Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            Utility.debug(exception);
        }
        if (image != null) {
            component.prepareImage(image, null);
        }
        return image;
    }

    public static String loadText(String string) {
        if (resourceDir != null) {
            string = resourceDir + string;
        }
        return new Utility().loadAText(string);
    }

    private String loadAText(String string) {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + "\n";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Utility.debug(exception);
        }
        return string2;
    }

    public static boolean areWeOnDOS() {
        return weAreOnDOS;
    }

    public static void setResourceDir(String string) {
        resourceDir = string;
    }

    public static String compileString(String string, Object[] objectArray, ResourceBundle resourceBundle) {
        String string2 = resourceBundle.getString(string);
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '%' || c == '@') {
                int n = -1;
                if (i < string2.length() - 1) {
                    switch (string2.charAt(i + 1)) {
                        case '%': {
                            if (c != '%') break;
                            stringBuffer.append('%');
                            ++i;
                            break;
                        }
                        case '@': {
                            if (c != '@') break;
                            stringBuffer.append("@");
                            ++i;
                            break;
                        }
                        case '0': {
                            n = 0;
                            break;
                        }
                        case '1': {
                            n = 1;
                            break;
                        }
                        case '2': {
                            n = 2;
                            break;
                        }
                        case '3': {
                            n = 3;
                            break;
                        }
                        case '4': {
                            n = 4;
                            break;
                        }
                        case '5': {
                            n = 5;
                            break;
                        }
                        case '6': {
                            n = 6;
                            break;
                        }
                        case '7': {
                            n = 7;
                            break;
                        }
                        case '8': {
                            n = 8;
                            break;
                        }
                        case '9': {
                            n = 9;
                            break;
                        }
                    }
                }
                if (n < 0 || n >= objectArray.length) continue;
                if (c == '%') {
                    stringBuffer.append(objectArray[n]);
                } else {
                    stringBuffer.append(resourceBundle.getString(objectArray[n].toString()));
                }
                ++i;
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public static Frame getFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return new Frame();
    }

    public static boolean equalBytes(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public static void setApplet(Applet applet) {
        Utility.applet = applet;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static boolean areWeInAnApplet() {
        return applet != null;
    }

    public static boolean getBooleanParameter(String string, boolean bl) {
        String string2 = Utility.getStringParameter(string, null);
        if (string2 != null) {
            return "true".equals(string2.toLowerCase());
        }
        return bl;
    }

    public static String getStringParameter(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = Utility.areWeInAnApplet() ? applet.getParameter(string) : System.getProperty(string);
            if (string3 != null) {
                return string3;
            }
        }
        catch (Exception exception) {
            Utility.debug(exception);
        }
        return string2;
    }

    public static Color getColorParameter(String string, Color color) {
        String string2 = Utility.getStringParameter(string, null);
        if (string2 != null) {
            try {
                return Color.decode(string2);
            }
            catch (Exception exception) {
                Utility.debug(exception);
            }
        }
        return color;
    }

    public static int getIntParameter(String string, int n) {
        return Utility.getIntParameter(string, n, 10);
    }

    public static int getIntParameter(String string, int n, int n2) {
        String string2 = Utility.getStringParameter(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return n;
    }

    public static double getDoubleParameter(String string, double d) {
        String string2 = Utility.getStringParameter(string, null);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return d;
    }

    public static float getFloatParameter(String string, float f) {
        String string2 = Utility.getStringParameter(string, null);
        if (string2 != null) {
            try {
                return Float.valueOf(string2).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                Utility.debug(numberFormatException);
            }
        }
        return f;
    }

    public static void debug(Object object) {
        if (debugging) {
            System.out.println(object == null ? "<null>" : object.toString());
        }
    }

    public static void debug(Throwable throwable) {
        if (debugging) {
            throwable.printStackTrace();
        }
    }

    public static void printProperty(String string) {
        try {
            Utility.debug(string + "=" + System.getProperty(string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void printProperties() {
        if (Utility.isDebug()) {
            String[] stringArray = new String[]{"java.version", "java.vendor", "os.name", "os.arch", "os.version"};
            for (int i = 0; i < stringArray.length; ++i) {
                Utility.printProperty(stringArray[i]);
            }
        }
    }

    public static boolean globEquals(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n > 0) {
            char c = string.charAt(0);
            switch (c) {
                case '*': {
                    return Utility.globEquals(string.substring(1), string2) || n2 > 0 && Utility.globEquals(string, string2.substring(1));
                }
                case '?': {
                    return n2 > 0 && Utility.globEquals(string.substring(1), string2.substring(1));
                }
            }
            return n2 > 0 && c == string2.charAt(0) && Utility.globEquals(string.substring(1), string2.substring(1));
        }
        return n == n2;
    }

    public static void addEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        if (exceptionWrapper == null) {
            exceptionWrapper = new EventQueueExceptionWrapper();
        }
        exceptionWrapper.addEventQueueExceptionListener(eventQueueExceptionListener);
    }

    public static void removeEventQueueExceptionListener(EventQueueExceptionListener eventQueueExceptionListener) {
        if (exceptionWrapper != null) {
            exceptionWrapper.removeEventQueueExceptionListener(eventQueueExceptionListener);
        }
    }

    public static Cursor createCustomCursor(Icon icon, Color color, String string, Cursor cursor) {
        return Utility.createCustomCursor(icon, color, null, string, cursor);
    }

    public static Cursor createCustomCursor(Icon icon, Color color, Point point, String string, Cursor cursor) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        if (dimension.width >= icon.getIconWidth() && dimension.height >= icon.getIconHeight()) {
            Cursor cursor2;
            int n = (dimension.width - icon.getIconWidth()) / 2;
            int n2 = (dimension.height - icon.getIconHeight()) / 2;
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            preparer.setBackground(color);
            icon.paintIcon(preparer, bufferedImage.getGraphics(), n, n2);
            if (point == null) {
                point = new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2);
            }
            if ((cursor2 = toolkit.createCustomCursor(bufferedImage, new Point(point.x + n, point.y + n2), string)) != null) {
                return cursor2;
            }
        }
        return cursor;
    }

    public static float getPhysiologicalBrightness(Color color) {
        return 0.3f * (float)color.getRed() / 255.0f + 0.53f * (float)color.getGreen() / 255.0f + 0.17f * (float)color.getBlue() / 255.0f;
    }

    public static Color getPhysiologicalGray(Color color) {
        float f = Utility.getPhysiologicalBrightness(color);
        return new Color(f, f, f);
    }

    public static float getColorBrightnessDistance(Color color, Color color2) {
        return Math.abs(Utility.getPhysiologicalBrightness(color) - Utility.getPhysiologicalBrightness(color2));
    }
}

