/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.DumpLoader;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.ProgressTimeLine;
import de.caff.asteroid.analysis.TimeLine;
import de.caff.util.KnockOffListener;
import de.caff.util.Worker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AnalysisApplet
extends JApplet {
    private static final String CARD_STANDARD = "standard";
    private static final String CARD_PROGRESS = "progress";
    public static final String PARAM_FILE = "file";
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private TimeLine timeLine = new TimeLine(null);
    private ProgressTimeLine progress = new ProgressTimeLine();
    private MinimalInfo infoLine = new MinimalInfo();

    public AnalysisApplet() {
        this.timeLine.addFrameListener(this.infoLine);
        this.infoLine.setBorder(BorderFactory.createEtchedBorder());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.timeLine, CARD_STANDARD);
        this.cardPanel.add((Component)this.progress, CARD_PROGRESS);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.cardPanel, "South");
        this.getContentPane().add((Component)this.infoLine, "North");
        this.getContentPane().add(new FrameKeyInfoDisplay(this.timeLine, new SimpleVelocityPreparer(), null, true));
    }

    public void init() {
        String file = this.getParameter(PARAM_FILE);
        if (file != null) {
            this.showDumpFile(file);
        }
    }

    public void showDumpFile(final String filename) {
        this.timeLine.setDumpFile(null);
        this.infoLine.refreshDumpFile();
        KnockOffListener ko = new KnockOffListener(){

            public void knockedOff(Worker worker) {
                AnalysisApplet.this.setCursor(Cursor.getDefaultCursor());
                AnalysisApplet.this.cardLayout.show(AnalysisApplet.this.cardPanel, AnalysisApplet.CARD_STANDARD);
                try {
                    worker.rethrow();
                    DumpLoader loader = (DumpLoader)worker;
                    AnalysisApplet.this.timeLine.setDumpFile(loader.getDumpFile());
                    AnalysisApplet.this.infoLine.refreshDumpFile();
                    AnalysisApplet.this.getAppletContext().showStatus("Loaded " + filename);
                }
                catch (Throwable x) {
                    JOptionPane.showMessageDialog(AnalysisApplet.this, new Object[]{"Cannot open '" + filename + "':", x.getMessage()}, "Error while reading Dump File", 0);
                }
            }
        };
        try {
            URL fileURL = new URL(this.getDocumentBase(), filename);
            System.out.println("URL: " + fileURL);
            DumpLoader worker = new DumpLoader(fileURL.openStream(), filename, ko, this.progress);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cardLayout.show(this.cardPanel, CARD_PROGRESS);
            new Thread((Runnable)worker, "Loader").start();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this, new Object[]{"Cannot open '" + filename + "':", e.getMessage()}, "Error while reading Dump File", 0);
        }
    }

    private class MinimalInfo
    extends JPanel
    implements FrameListener {
        private JLabel fileInfo;
        private JLabel frameInfo;
        private JLabel keyInfo;

        MinimalInfo() {
            super(new BorderLayout());
            this.fileInfo = new JLabel();
            this.frameInfo = new JLabel();
            this.keyInfo = new JLabel();
            Box box = Box.createHorizontalBox();
            box.add(this.fileInfo);
            box.add(this.frameInfo);
            box.add(Box.createHorizontalGlue());
            box.add(this.keyInfo);
            this.add((Component)box, "Center");
        }

        public void frameReceived(FrameInfo frame) {
            if (frame == null) {
                this.frameInfo.setText("???");
                this.keyInfo.setText("???");
            } else {
                this.frameInfo.setText(String.format(" #%d", frame.getIndex()));
                FrameKeyInfo info = AnalysisApplet.this.timeLine.getCurrentInfo();
                List<FrameKeyInfo.ButtonInfo> buttons = info.getButtons();
                StringBuilder b = new StringBuilder();
                if (!buttons.isEmpty()) {
                    Buttons keys = buttons.get(buttons.size() - 1).getButtons();
                    if (keys.isFirePressed()) {
                        b.append("<FIRE>");
                    }
                    if (keys.isHyperspacePressed()) {
                        b.append("<HYPER>");
                    }
                    if (keys.isThrustPressed()) {
                        b.append("<THRUST>");
                    }
                    if (keys.isLeftPressed()) {
                        b.append("<LEFT>");
                    }
                    if (keys.isRightPressed()) {
                        b.append("<RIGHT>");
                    }
                    if (keys.isStartPressed()) {
                        b.append("<START>");
                    }
                }
                this.keyInfo.setText(b.length() == 0 ? "<>" : b.toString());
            }
        }

        void refreshDumpFile() {
            DumpFile dumpFile = AnalysisApplet.this.timeLine.getDumpFile();
            if (dumpFile == null) {
                this.fileInfo.setText("???");
                this.frameReceived(null);
            } else {
                StringBuilder b = new StringBuilder(dumpFile.getFilename());
                if (dumpFile.getIpAddress() != null) {
                    b.append(" [").append(dumpFile.getIpAddress()).append(":").append(dumpFile.getClientPort());
                    if (dumpFile.getPlayerName() != null) {
                        b.append("; ").append(dumpFile.getPlayerName());
                    }
                    b.append("]");
                }
                this.fileInfo.setText(b.toString());
                this.frameReceived(AnalysisApplet.this.timeLine.getCurrentInfo().getFrameInfo());
            }
        }
    }
}

